### Name: generation
### Title: Calculate generation value
### Aliases: generation generation<-
### Keywords: manip misc

### ** Examples

  # Nonoverlapping pedigree
  ped <- generatePedigree(nId=5, nGeneration=4, nFather=1, nMother=2)
  ped$generation1 <- generation(ped)
  ped

  # Overlapping Pedigree
  ped <- data.frame(     id=c(1, 2, 3, 4, 5, 6, 7),
                     father=c(0, 0, 2, 2, 2, 4, 4),
                     mother=c(0, 0, 1, 0, 3, 3, 5),
                    dtBirth=c(2, 1, 3, 4, 5, 6, 7))
  ped <- Pedigree(ped, unknown=0, dtBirth="dtBirth")
  generation(ped) <- generation(ped)

  # Overlapping pedigree + one individual (4) comes late in pedigree and
  # has no ascendants
  ped <- data.frame(     id=c(1, 2, 3, 4, 5, 6, 7),
                     father=c(0, 0, 2, 0, 2, 4, 4),
                     mother=c(0, 0, 1, 0, 3, 3, 5),
                    dtBirth=c(2, 1, 3, 2, 5, 6, 7))
  ped <- Pedigree(ped, unknown=0, dtBirth="dtBirth")
  generation(ped)
  generation(ped, generationOrder="decreasing",
             col="generazione") <- generation(ped, generationOrder="decreasing")



