### Name: extend
### Title: Extend pedigree
### Aliases: extend
### Keywords: manip misc

### ** Examples

  # --- Toy example ---
  ped <- generatePedigree(nId=5, nGeneration=4, nFather=1, nMother=2)
  ped <- ped[10:20,]
  ped[5, "father"] <- NA # to test robustnes of extend on NA
  extend(ped)
  extend(ped, top=FALSE)

  ## Extend only ascendant and their generation
  extend(ped, col="generation")
  extend(ped, col=c("generation", "sex"))

  # --- Bigger example ---
  ped <- generatePedigree(nId=1000, nGeneration=10, nFather=100,
                          nMother=500)
  nrow(ped)
  # Now keep some random individuals
  ped <- ped[unique(sort(round(runif(n=nrow(ped)/2, min=1,
                                     max=nrow(ped))))), ]
  nrow(ped)
  nrow(extend(ped))



