### Name: readExpressionSet
### Title: Read 'ExpressionSet'
### Aliases: readExpressionSet
### Keywords: file manip

### ** Examples


## Create a temporary file for expression data

exprsFile <- tempfile()
data(geneData)
write.table(geneData[,1:6], exprsFile, quote = FALSE, sep = "\t",
            row.names = TRUE, col.names = TRUE)

## Create a temporary file with a structure like that from 'Save
## as...' text file from a popular spreadsheet (see
## read.AnnotatedDataFrame)

phenoDataFile <- tempfile()
df <- data.frame(Id=paste("Sample", 1:6),
                 x=1:6,
                 y=rep(c("Low", "High"), 3),
                 z=I(letters[1:6]))
write.table(df, phenoDataFile, quote=FALSE, sep="\t", row.names=FALSE)

## Read ExpressionSet with appropriate parameters

obj <- readExpressionSet(exprsFile, phenoDataFile, header=TRUE, sep="\t")
obj

unlink(c("exprsFile", "phenoDataFile"))




