### Name: make.grid
### Title: Make a matrix of values allocated in a two dimensional grid
### Aliases: make.density make.grid
### Keywords: manip hplot

### ** Examples

 
  if (require(rfcdmin)){
   data.there<-is.element(c("st.1829", "unst.1829", "st.DRT", "unst.DRT"),objects())
   if ( ( sum(data.there) != length(data.there) )){
      ## obtaining the FCS objects from VRC data
      data(VRCmin)
  }

var1<-st.DRT@data[,4]
var2<-st.DRT@data[,5]
var1.2<-unst.DRT@data[,4]
var2.2<-unst.DRT@data[,5]

col.nm<-colnames(st.DRT@data)

## The status where 1=stimulated
## 0 = unstimulated
status<-c(rep(1, dim(st.DRT@data)[1]), rep(0, dim(unst.DRT@data)[1]))
x <- c(var1, var1.2)
y <-c(var2, var2.2)

count.output1<-make.grid(var1, var2)
count.output0<-make.grid(var1.2, var2.2)

## matrix of counts
mat.counts1<-count.output1$z
mat.counts0<-count.output0$z
##total observations
total.stimulated<-count.output1$n.cells
total.unstimulated<-count.output0$n.cells

count.diff.output <-make.density(x, y, status=status, type.CSP="count.diff")
## matrix of cont differences between the status categories
mat.count.diff <-count.diff.output$z

p.hat.output <-make.density(x, y, status=status, type.CSP="p.hat")
## matrix of cont differences between the status categories
mat.p.hat <-p.hat.output$z

p.hat.norm.output <-make.density(x, y, status=status, type.CSP="p.hat.norm")
## matrix of cont differences between the status categories
mat.p.hat.norm <-p.hat.norm.output$z

z.stat.output <-make.density(x, y, status=status, type.CSP="z.stat")
## matrix of cont differences between the status categories
mat.z.stat <-z.stat.output$z

if (interactive()){
par(mfrow=c(3,2))

image(mat.counts1,yaxt="n", xaxt="n",
  main="make.grid: Counts for stimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], col=heat.colors(20))

image( mat.counts0,yaxt="n", xaxt="n",
  main="make.grid: Counts for unstimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], col=heat.colors(20))

image( mat.count.diff,yaxt="n", xaxt="n",
  main="make.density: Count Difference (Stimulated-Unstimulated)",
   xlab=col.nm[4],
   ylab=col.nm[5], col=heat.colors(20))

image( mat.p.hat,yaxt="n", xaxt="n",
  main="make.density: Proportion of Stimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], col=heat.colors(20))

image( mat.p.hat.norm,main="make.density: Normalized proportion of Stimulated",
   xlab=col.nm[4],yaxt="n", xaxt="n",
   ylab=col.nm[5], col=heat.colors(20))

image( mat.z.stat, main="make.density: z statistic",
   xlab=col.nm[4],yaxt="n", xaxt="n",
   ylab=col.nm[5], col=heat.colors(20))

}
}




