### Name: summarizeByRegion
### Title: Compute Summary Statistics of Genome Regions
### Aliases: summarizeByRegion cgma
### Keywords: manip

### ** Examples


## 
## NOTE: This requires an annotation package to work.
##       In this example packages "hu6800" and "golubEsets" are used.
##       They can be downloaded from http://www.bioconductor.org
##       "hu6800" is under MetaData, "golubEsets" is under Experimental Data.

if(require(hu6800) && require(golubEsets)) {
   data(Golub_Train)
   cloc <- buildChromMap("hu6800",c("1p","1q","2p","2q","3p","3q"))

   ## For one-color expression data
   ## compare the ALL samples to the AML samples
   ## not particularly informative in this example

   aml.ix <- which(Golub_Train$"ALL.AML" == "AML")
   bias <- cgma(eset=Golub_Train,ref=aml.ix,genome=cloc)
   regmap(bias,col=.rwb) 
} else print("This example requires the hu6800 and golubEsets data
   packages.")

## A more interesting example

## The mcr.eset is a two-color gene expression exprSet
## where cytogenetically complex (MCR), 
## cytogenetically simple (CN) leukemia samples
## and normal control (MNC) samples were profiled against
## a pooled-cell line reference
## The MCR eset data was obtained with permission. See PMID: 15377468

## Notice the dimished expression on chromosome 5 in the MCR samples
## and the enhanced expression on chromosome 11
## This reflects chromosome gains and losses as validated by CGH

   data("mcr.eset")
   data(idiogramExample)
   norms <- grep("MNC",colnames(mcr.eset@exprs))
   bias <- cgma(mcr.eset,vai.chr,ref=norms)
   regmap(bias,col=topo.colors(50)) 



