### Encoding: latin1

### Name: svdImpute
### Title: SVDimpute algorithm
### Aliases: svdImpute
### Keywords: multivariate

### ** Examples

## Load a sample metabolite dataset (metaboliteData)
data(metaboliteData)

# Now remove 10% of the data
rows <- nrow(metaboliteData)
cols <- ncol(metaboliteData)
cond<-matrix(runif(rows * cols),rows,cols) < 0.1
metaboliteData[cond] <- NA

## Perform probabilistic PCA using the 3 largest components
result <- pca(metaboliteData, method="svdImpute", nPcs=3, center = TRUE)

## Get the estimated principal axes (loadings)
loadings <- result@loadings

## Get the estimated scores
scores <- result@scores

## Get the estimated complete observations
cObs <- result@completeObs

## Now plot the scores
plotPcs(result, scoresLoadings=c(TRUE,FALSE))




