/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.util;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.systemsbiology.gaggle.util.TextFileReader;
import org.systemsbiology.gaggle.util.TextHttpReader;
import org.systemsbiology.gaggle.util.TextJarReader;

public class NewNameHelper
implements Serializable {
    protected String uri;
    protected String rawText;
    protected String[] titles = new String[0];
    protected HashMap map = new HashMap();
    protected HashMap canonicalToCommonMap = new HashMap();
    protected HashMap commonToCanonicalMap = new HashMap();

    public NewNameHelper(String string) throws Exception {
        String string2;
        this.uri = string;
        int n = string.indexOf("://");
        if (n < 0) {
            string = "file://" + string;
            n = string.indexOf("://");
        }
        if ((string2 = string.substring(0, n + 3)).equals("file://")) {
            String string3 = string.substring(7);
            File file = new File(string3);
            if (!file.exists()) {
                throw new IllegalArgumentException("cannot find file named '" + string3 + "'");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("cannot read file named '" + string3 + "'");
            }
            TextFileReader textFileReader = new TextFileReader(file.getPath());
            textFileReader.read();
            this.rawText = textFileReader.getText();
        } else if (string2.equals("jar://")) {
            TextJarReader textJarReader = new TextJarReader(string);
            textJarReader.read();
            this.rawText = textJarReader.getText();
        } else if (string2.equals("http://")) {
            TextHttpReader textHttpReader = new TextHttpReader(string);
            textHttpReader.read();
            this.rawText = textHttpReader.getText();
        }
        if (this.rawText != null) {
            this.parseText(this.rawText);
        }
    }

    public String getRawText() {
        return this.rawText;
    }

    protected void parseText(String string) {
        String[] stringArray = string.split("\n");
        this.titles = stringArray[0].split("\t");
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("\t");
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("commonName", string3);
            for (int j = 0; j < this.titles.length; ++j) {
                hashMap.put(this.titles[j], stringArray2[j]);
            }
            this.map.put(string2, hashMap);
            this.map.put(string3, hashMap);
            this.canonicalToCommonMap.put(string2, string3);
            this.commonToCanonicalMap.put(string3, string2);
        }
    }

    public String[] getTitles() {
        return this.titles;
    }

    public String[] getCanonicalNames() {
        return this.map.keySet().toArray(new String[0]);
    }

    public HashMap getInfo(String string) {
        return (HashMap)this.map.get(string);
    }

    public String getCommonName(String string) {
        return (String)this.canonicalToCommonMap.get(string);
    }

    public String getCanonicalName(String string) {
        return (String)this.commonToCanonicalMap.get(string);
    }
}

