### Name: Ragraph-class
### Title: Class "Ragraph": A class to handle libgraph representations
### Aliases: Ragraph-class Ragraph agraph laidout layoutType edgemode
###   boundBox show,Ragraph-method edgeNames,Ragraph-method
###   AgEdge,Ragraph-method AgEdge<-,Ragraph-method agraph,Ragraph-method
###   boundBox,Ragraph-method laidout,Ragraph-method
###   layoutType,Ragraph-method edgemode,Ragraph-method
###   AgNode,Ragraph-method AgNode<-,Ragraph-method
###   getNodeLW,Ragraph-method getNodeRW,Ragraph-method
###   getNodeHeight,Ragraph-method getNodeXY,Ragraph-method getNodeXY
###   getNodeNames getNodeLabels
### Keywords: classes

### ** Examples

set.seed(123)
V <- letters[1:10]
M <- 1:4
g1 <- randomGraph(V, M, .2)
z <- agopen(g1,"foo")
z

## The various methods in action

## These methods are all used to obtain positional information about nodes
getNodeXY(z)
getNodeHeight(z)
getNodeLW(z)
getNodeRW(z)

## Retrieve information about the edges in the graph
edgeNames(z)
edgemode(z)

## These get information about the layout
laidout(z)
layoutType(z)
boundBox(z)

## Used to retrieve the entire list of edges or nodes
AgEdge(z)
AgNode(z)



