mxy2.plot                package:OLIN                R Documentation

_G_e_n_e_r_a_t_i_o_n _o_f _M_X_Y _p_l_o_t_s _b_a_s_e_d _o_n _s_p_o_t _c_o_o_r_d_i_n_a_t_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     This function produce a MXY plot with a colour bar. In contrast to
     'mxy.plot', the plot is  based on spot coordinates (instead on
     column and row  index as proxies for spot location).

_U_s_a_g_e:

     mxy2.plot(V,X,Y,Ngc,Ngr,Nsc,Nsr,color.lim=c(-1,1),xlab="X",ylab="Y",...) 

_A_r_g_u_m_e_n_t_s:

       V: vector of real values typically logged ratios _M_. 

       X: vector of x coordinates of spot locations

       Y: vector of y coordinates of spot locations

     Ngc: number of columns for the grid matrix

     Ngr: number of rows for the grid matrix

     Nsc: number of columns for the spot matrix

     Nsr: number of rows for the spot matrix

color.lim: limits of color range for MXY plot

    xlab: label of x-axis of MXY plot

    ylab: label of y-axis of MXY plot

     ...: Further optional graphical parameter for the 'image' function
          generating the MXY plot

_D_e_t_a_i_l_s:

     The function 'mxy2.plot' can be used to plot the distribution of
     'V' across the array. As 'mxy.plot', it mainly aims for the
     plotting of the distribution of logged fold changes. It differs
     from 'mxy.plot' in the representation of spot location. The
     function 'mxy.plot' uses the index of columns and rows as proxies
     for the spot location. The gaps between the grid matrices (spotted
     by different pins) are, therefore, not reproduced in the plot. A
     more accurate spatial plot is produced by 'mxy2.plot', which is
     based on the coordinates of the first column and first raw of the
     array. Assuming a regular rectangular print layout, gaps and the
     edges of the array are shown.

_A_u_t_h_o_r(_s):

     Matthias E. Futschik (<URL:
     http://itb.biologie.hu-berlin.de/~futschik>)

_S_e_e _A_l_s_o:

     'mxy.plot', 'v2m', 'm2v', 'fgbg.visu', 'image'

_E_x_a_m_p_l_e_s:

     # LOADING DATA
     data(sw)
     data(sw.xy)
     # PLOTTING
     mxy2.plot(maM(sw)[,1],X=sw.xy$X[,1],Y=sw.xy$Y[,1], Ngc=maNgc(sw),Ngr=maNgr(sw),
                        Nsc=maNsc(sw),Nsr=maNsr(sw))

