### Name: and.segSet
### Title: Intersection of segments
### Aliases: and.segSet &.segSet and and.default
### Keywords: utilities

### ** Examples

a = matrix(c(1,5,15,45,17,38,
             100,120,130,140,
             135,145,142,160),
             ncol=2,byrow=TRUE)
b  = matrix(c(15,18, 28,45,
              1,10, 15,20, 25,40,
              17,23, 35,38,100,105,
              110,120),ncol=2,byrow=TRUE)

a <- as.segSet(a)
b <- as.segSet(b)

c = and(a,b)
par(mfrow=c(3,1))
plot(a,xlim=c(1,160))
plot(b,xlim=c(1,160))
plot(c,xlim=c(1,160))

## Another sample

a = matrix(c(1,30,40,50,60,70,80,110),ncol=2,byrow=TRUE)
b = matrix(c(1,10,20,30,40,70,80,90,100,110),ncol=2,byrow=TRUE)
a <- as.segSet(a)
b <- as.segSet(b)

c = and(a,b)
par(mfrow=c(3,1))
plot(a,xlim=c(1,160),main="A")
plot(b,xlim=c(1,160),main="B")
plot(c,xlim=c(1,160),main="A&B")

## Show result
c
and(a)



