### Name: volcano
### Title: Volcano plot for F test results
### Aliases: volcano
### Keywords: hplot

### ** Examples

data(paigen)
paigen <- createData(paigen.raw, n.rep=2)

# make model without interaction
model.noint.fix <- makeModel(data=paigen, formula=~Array+Dye+Spot+Strain+Diet)

# F-test strain effect
## Not run: 
##D test.strain.fix <- matest(paigen, model.noint.fix, term="Strain", n.perm=500,
##D         shuffle.method="resid", test.method=rep(1,4))
##D # volcano plot
##D idx.strain.fix <- volcano(test.strain.fix, title="Strain test - fixed model")
##D 
##D # T-test all pairwise comparison on strain
##D C <- matrix(c(1,-1,0,1,0,-1, 0,1,-1), nrow=3, byrow=TRUE)
##D ttest.strain.fix <- matest(paigen, model.noint.fix, term="Strain",
##D          Contrast=C, n.perm=500, test.method=rep(1,4))
##D # volcano plot
##D volcano(ttest.strain.fix)
## End(Not run)



