### Name: readCdfUnits
### Title: Reads units (probesets) from an Affymetrix CDF file
### Aliases: readCdfUnits
### Keywords: file IO

### ** Examples

for (zzz in 0) {

# Find any CDF file
cdfFile <- findCdf()
if (is.null(cdfFile))
  break

# Read all units in a CDF file [~20s => 0.34ms/unit]
cdf0 <- readCdfUnits(cdfFile)

# Read a subset of units in a CDF file [~6ms => 0.06ms/unit]
units1 <- c(5, 100:109, 34)
cdf1 <- readCdfUnits(cdfFile, units=units1)
stopifnot(identical(cdf1, cdf0[units1]))
rm(cdf0)

# Create a unit name to index map
names <- readCdfUnitNames(cdfFile)
units2 <- match(names(cdf1), names)
stopifnot(identical(units1, units2))
cdf2 <- readCdfUnits(cdfFile, units=units2)

stopifnot(identical(cdf1, cdf2))

# Clean up
rm(cdfFile, units1, cdf1, names, units2, cdf2)
} # for (zzz in 0)



