### Name: mfuzz
### Title: Function for soft clustering based on fuzzy c-means.
### Aliases: mfuzz
### Keywords: cluster

### ** Examples

if (interactive()){
data(yeast)
# Data pre-processing
yeastF <- filter.NA(yeast)
yeastF <- fill.NA(yeastF) # for illustration only; rather use knn method
yeastF <- standardise(yeastF)

# Soft clustering and visualisation
cl <- mfuzz(yeastF,c=20,m=1.25)
mfuzz.plot(yeastF,cl=cl,mfrow=c(2,2))

# Plotting center of cluster 1 
X11(); plot(cl[[1]][1,],type="l",ylab="Expression") 

# Getting the membership values for the first 10 genes in cluster 1
cl[[4]][1:10,1] 
}



