### Name: ggm.test.edges
### Title: Graphical Gaussian Models: Testing Edges
### Aliases: ggm.test.edges ggm.list.edges
### Keywords: htest

### ** Examples

# load GeneTS library
library("GeneTS")
 
# ecoli data 
data(ecoli)

# estimate partial correlation matrix 
inferred.pcor <- ggm.estimate.pcor(ecoli)

# p-values, q-values and posterior probabilities for each edge 
#
test.results <- ggm.test.edges(inferred.pcor)

# show best 20 edges (strongest correlation)
test.results[1:20,]

# how many are significant based on FDR cutoff Q=0.05 ?
num.significant.1 <- sum(test.results$qval <= 0.05)
test.results[1:num.significant.1,]

# how many are significant based on "local fdr" cutoff (prob > 0.95) ?
num.significant.2 <- sum(test.results$prob > 0.95)
test.results[1:num.significant.2,]

# parameters of the mixture distribution used to compute p-values etc.
c <- cor.fit.mixture(sm2vec(inferred.pcor))
c$eta0
c$kappa



