### Name: ggm.plot.graph
### Title: Graphical Gaussian Models: Plotting the Network
### Aliases: ggm.plot.graph ggm.make.graph show.edge.weights
### Keywords: hplot

### ** Examples

# load GeneTS library
library("GeneTS")
 
# generate random network with 20 nodes and 10 percent edges (=19 edges)
true.pcor <- ggm.simulate.pcor(20, 0.1)

# convert to edge list 
test.results <- ggm.list.edges(true.pcor)[1:19,]

# generate graph object 
# NOTE: this requires the installation of the "graph" package
# (in the following "try" is used to avoid an error if the library is not installed)
nlab <- LETTERS[1:20]
try( gr <- ggm.make.graph( test.results, nlab) )
try( gr )
try( show.edge.weights(gr) )
try( gr2 <- ggm.make.graph( test.results, nlab, drop.singles=TRUE) )
try( gr2 )

# plot network
# NOTE: this requires the installation of the "Rgraphviz" library
try ( ggm.plot.graph(gr, main = "A graph"))
try ( ggm.plot.graph(gr2, main = "The same graph with singles removed" ))



