### Name: add.parallel.coordinates
### Title: Add a parallel coordinates line to an existing plot
### Aliases: add.parallel.coordinates
### Keywords: hplot

### ** Examples


if (require(rfcdmin)){

data.there<-is.element("MC.053",objects())
if ( ( sum(data.there) != length(data.there) )){
## obtaining the FCS objects from VRC data
data(MC.053min)
}

dataMC<-MC.053@data


if (interactive()){
par(mfrow=c(2,2))
### subset the data to the first 5 observations because it is too huge
parallel.coordinates(dataMC[c(1:5),-6])

## adding in the 6-th row observation
add.parallel.coordinates(dataMC[6,-6], col="red")

### the same plot is scaled to 0,1 range
parallel.coordinates(dataMC[c(1:5),-6], scaled=TRUE)
## adding in the 6-th row observation
add.parallel.coordinates(dataMC[6,-6], scaled=TRUE, col="red")

## positions on the horizontal x-axis
parallel.coordinates(dataMC[c(1:5),1:4], varlabpos=c(1, 5, 8, 16))
## adding in the 6-th row observation
add.parallel.coordinates(dataMC[6,1:4], varlabpos=c(1,5,8,16),
col="red")
}

}



