### Name: ImageParCoord
### Title: Image Parallel Coordinates Plot: Joint and marginal
### Aliases: ImageParCoord JointImageParCoord
### Keywords: hplot

### ** Examples


  if (require(rfcdmin)){

    data.there<-is.element(c("st.1829", "unst.1829", "unst.DRT", "st.DRT"),objects())
    if ( ( sum(data.there) != length(data.there) )){
      ## obtaining the FCS objects from VRC data
      data(VRCmin)
    }

    if (interactive()==TRUE){
    par(mfrow=c(3,3))

    ImageParCoord(unst.1829@data[1:1000, 1:3], num.bins=16,
              title="1000 obs 16 bins 5 trans", ntrans=5)
    ## joint line plot
    JointImageParCoord(unst.1829@data[1:1000,c(1,2,3)], num.bins=16,
              title="1000 obs 16 bins 5 trans", ntrans=5)

    ## color image is changed
    ImageParCoord(unst.1829@data[1:1000,c(1,2,3)], num.bins=20,
              title="1000 obs 20 bins 5 trans", color.image=rainbow(16,
              start=.4, end=.1), ntrans=5)

    par(mfrow=c(3,3))
    ImageParCoord(unst.1829@data[1:1000,c(1,2,3)], num.bins=20,
              title="1000 obs 20 bins 10 trans", ntrans=10)
    ## joint line plot

    JointImageParCoord(unst.1829@data[1:1000,c(1,2,3)], num.bins=20,
              title="1000 obs 20 bins 10 trans", ntrans=10)

    ## plot the parallel coordinates plot also
    par(mfrow=c(2,2))
    ImageParCoord(unst.1829@data[1:1000,c(1,2,3)], 1:1000, num.bins=16,
              color.image=gray((25:5/25)[-c(1, 2, 3, 4, 5, 6,7)]),
              title="1000 obs 16 bins 5 trans", ntrans=5,
              para.plotted=TRUE)

    ## plot the parallel coordinates plot also
    par(mfrow=c(2,2))
    JointImageParCoord(unst.1829@data[1:1000,c(1,2,3)],
              1:1000, num.bins=16,
              color.image=gray((25:5/25)[-c(1, 2, 3, 4, 5, 6,7)]),
              title="1000 obs 16 bins 5 trans", ntrans=5,
              para.plotted=TRUE)

    ##histograms only
    par(mfrow=c(3,3))
    ImageParCoord(unst.1829@data[1:1000,c(1,2,3)], num.bins=10,
             title="1000 obs 10 bins 1 trans",
             ntrans=1, hist.plotted=TRUE,
             image.plotted=FALSE, legend.plotted=FALSE,
             lines.plotted=FALSE)

    ## histograms and images
    par(mfrow=c(3,3))
    ImageParCoord(unst.1829@data[1:1000,c(1,2,3)],
           num.bins=10,
           title="1000 obs 10 bins 5 trans",
           ntrans=5, hist.plotted=TRUE)

    ## legend only
    ImageParCoord(unst.1829@data[1:1000,c(1,2,3)], num.bins=10,
             title="1000 obs 10 bins 5 trans", ntrans=5, legend.plotted=TRUE,
             image.plotted=FALSE, lines.plotted=FALSE)

    JointImageParCoord(unst.1829@data[1:1000,c(1,2,3)],
             num.bins=10,
             title="1000 obs 10 bins 5 trans",
             ntrans=5, legend.plotted=TRUE,
             image.plotted=FALSE, lines.plotted=FALSE)
    }
  }




