### Name: transform.madata
### Title: Micro Array experiment data transformation
### Aliases: transform.madata transform.rawdata
### Keywords: smooth

### ** Examples

# load in data
data(kidney)
# do regional loess on raw data
## Not run: 
##D raw.lowess <- transform(kidney.raw, method="rlowess")
##D graphics.off()
##D 
##D # make data object and do normalization on it
##D # create data object with collapsing replicates
##D data1<-createData(kidney.raw)
##D # do shift without displaying the plot
##D data1.shift <- transform(data1, method="shift", lolim=-50, uplim=50,
##D          draw="off")
##D 
##D # do global lowess and output the plots to a postscript file
##D postscript(file="glowess.ps")
##D data1.glowess <- transform(data1, method="glowess", draw="dev")
##D graphics.off()
##D 
##D # do linear-log
##D data1.linlog <- transform(data1, method="linlog")
##D graphics.off()
##D 
##D # do linear-log shift
##D data1.linlogshift <- transform(data1, method="linlogshift", lolim=-50,
##D   uplim=50)
##D graphics.off()
## End(Not run)



