### Name: makeModel
### Title: Make model object for N-dye Micro Array experiment
### Aliases: makeModel
### Keywords: models

### ** Examples

#load in data
data(paigen)
# make data object with rep 2
paigen <- createData(paigen.raw, 2)
# make full model for fixed effect model
model.full.fix <- makeModel(data=paigen,
      formula=~Dye+Array+Spot+Strain+Diet+Strain:Diet)
summary(model.full.fix)
# make full model for mixed effect model
model.full.mix <- makeModel(data=paigen,
      formula=~Dye+Array+Spot+Strain+Diet+Strain:Diet+Sample,
      random=~Array+Spot+Sample)
summary(model.full.mix)



