### Name: kooperberg_old
### Title: Kooperberg Model-Based Background Correction
### Aliases: kooperberg_old
### Keywords: models

### ** Examples

#  This is example code for reading and background correcting GenePix data
#  given GenePix Results (gpr) files in the working directory (data not
#  provided).
## Not run: 
##D genepixFiles <- dir(pattern="*\\.gpr$") # get the names of the GenePix image analysis output files in the current directory
##D read.series(genepixFiles, suffix=NULL, skip=26, sep="\t") # read the files into data.frames, assuming headers of 26 lines
##D gal <- readGAL()
##D layout <- getLayout(gal)
##D RGmodel <- kooperberg_old(genepixFiles, layout=layout) # model-based background correction
##D MA <- normalizeWithinArrays(RGModel) # normalize the data
## End(Not run)



