### Name: getHomolog
### Title: Get homologs
### Aliases: getHomolog
### Keywords: methods

### ** Examples

if(interactive()){
mart <- martConnect()

#HUGO to Entrez Gene

homolog = getHomolog(id = 1:20, from.species = 'hsapiens', to.species = 'mmusculus', from.type = 'entrezgene', to.type = 'refseq', mart = mart)
show(homolog)

#ensembl to ensembl

homolog = getHomolog( id = "ENSG00000072778", from.species = "hsapiens", from.type = "ensembl", to.type="ensembl",to.species="mmusculus", mart = mart )
show(homolog)

#Affy to Affy

homolog = getHomolog( id = "1424184_at", to.array = "hg_u95av2", from.array = "mouse430a_2", mart = mart )
show(homolog)

#Affy to ensembl

homolog = getHomolog( id = "1424184_at", to.species = "hsapiens", to.type = "ensembl", from.array = "mouse430a_2", mart = mart )
show(homolog)

martDisconnect(mart = mart)
}



