### Name: mergeExprs
### Title: Merge gene expression data sets
### Aliases: mergeExprs AverageDuplicates check mergeget
### Keywords: manip

### ** Examples

 
  data(mergeData)
  merged  <-mergeExprs(sample1,sample2,sample3)

  rr<-rnorm(200*22,0,1)
  mm<-matrix(rr,200,22)
  rownames(mm)<-geneNames(sample2)
  merge.m<-mergeExprs(sample1,mm,sample2)
  intcor.m<-intCor(merge.m)
  plot(intcor.m)

  rr<-rnorm(200*50,0,1)
  mm2<-matrix(rr,200,50)
  ph.ll<-as.data.frame(rbinom(200,1,.5))
  ll<-list(mm2,ph.ll,geneNames(sample2),"list 2")
  merge.t<-mergeExprs(sample1,mm,sample2,ll)
  intcor.t<-intCor(merge.t)
  plot(intcor.t)

  merge.a<-mergeExprs(sample3,merge.m,ll)
  inter<-intersection(merge.a)
  summary(merge.a)
  



