### Name: fdr.estimate.eta0
### Title: Estimate the Proportion of Null p-Values
### Aliases: fdr.estimate.eta0
### Keywords: htest

### ** Examples

# load mixfdr library
library("GeneTS")

# simulate case-control data
p <- 100 # total number of variables
d <- 20  # number of cases where case and control differs
n <- 5   # sample size per group

r1a <- rnorm(d*n,     mean = 3, sd = 1)
r1b <- rnorm((p-d)*n, mean = 0, sd = 1)
r2 <- rnorm(p*n, mean = 0, sd = 1)
x1 <- matrix(c(r1a, r1b), nrow = p, byrow = TRUE) # group 1.
x2 <- matrix(r2, nrow = p, byrow = TRUE) # group 2.

# p-values from t-test
pval <- numeric(p)
for(i in 1:p) pval[i] <- t.test(x1[i, ], x2[i, ])$p.value

# Proportion of null p-values for different methods
fdr.estimate.eta0(pval)
fdr.estimate.eta0(pval, method="adaptive")
fdr.estimate.eta0(pval, method="bootstrap")
fdr.estimate.eta0(pval, method="smoother")

# FDR test on the level 0.05 (assuming eta0=0
fdr.control(pval, Q = 0.05)  

# FDR test on the level 0.05 (estimating eta0)
e0 <- fdr.estimate.eta0(pval, method="adaptive")
fdr.control(pval, Q = 0.05, eta0=e0)  



