### Name: Translation
### Title: Translation from DNA trinucleotides to proteine
### Aliases: translate strTranslate showTable
### Keywords: utilities

### ** Examples

s<-"gtcatgcatgctaggtgacagttaaaatgcgtctaggtgacagtctaacaa"

# Simple usage:
strTranslate(s)
#[1] "VMHAR*QLKCV*VTV*Q"

# with buffers
placeString(s)
translate()
# the same...
#[1] "VMHAR*QLKCV*VTV*Q"

# with 2 positions
translate (from=c(1,2),to=c(0,0))
#[1] "VMHAR*QLKCV*VTV*Q" "SCMLGDS*NASR*QSN" 

# with 2 strands
translate (from=c(1,2,1),to=c(0,0,0),strand=c(0,0,1))
#[1] "VMHAR*QLKCV*VTV*Q" "SCMLGDS*NASR*QSN"  "LLDCHLDAF*LSPSMHD"

# With Invertebrate Mitochondrial Code
translate(code=4)
#[1] "VMHASWQLKCV*VTV*Q"

# With a personal code
translate(charcode="FFLLxxxxYY**CCwwLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRuuuuAAAADDEEGGGG")
#[1] "uMHARwQLKCu*uTu*Q"

# Show what is this code...
showTable(charcode="FFLLxxxxYY**CCwwLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRuuuuAAAADDEEGGGG")
#      [,1]  [,2]
# [1,] "UUU" "F" 
# [2,] "UUC" "F" 
# [3,] "UUA" "L" 
# [4,] "UUG" "L" 
# [5,] "UCU" "x" 
# [6,] "UCC" "x" 
# [7,] "UCA" "x" 
# ...

# Show Standard table:
showTable()

# Show  Invertebrate Mitochondrial Code
showTable(code=4)




