### Name: esApply
### Title: Apply for the Expression Data in 'exprSet'
### Aliases: esApply
### Keywords: models methods

### ** Examples

data(eset)

# we know that eset has covariates in the pData called "cov1" and "cov2"
# here cov1 is an unbound value, it will be resolved by using the pData
# here are two functions conforming to the esApply protocol

mytt.demo <- function(y) {
 ys <- split( y, cov1 )
 t.test( ys[[1]], ys[[2]] )$p.value
 }

# obtain the p value of the slope associated with cov2, adjusting for cov1
# (if we were concerned with sign we could save the z statistic instead at coef[3,3]
myreg.demo <- function( y ) {
   summary(lm(y~cov1+cov2))$coef[3,4]
}

newt <- esApply( eset, 1, mytt.demo )

# a resampling method
resamp <- function( ESET ) {
 ntiss <- ncol(exprs(ESET))
 newind <- sample(1:ntiss, size=ntiss, replace=TRUE)
 ESET[newind,]
 }

# a filter
q3g100filt <- function( eset ) {
 apply( exprs(eset), 1, function(x)quantile(x,.75)>100 )
 }

# filter after resampling and then apply
set.seed(123)
rest <- esApply( { bool <- q3g100filt(resamp(eset)); eset[bool,] }, 1,
mytt.demo )




