###################################################
### chunk number 1: 
###################################################
options(width = 95)


###################################################
### chunk number 2: 
###################################################
library(topGO)
library(ALL)
data(ALL)
data(geneList)


###################################################
### chunk number 3: 
###################################################
affyLib <- paste(annotation(ALL), "db", sep = ".")
library(package = affyLib, character.only = TRUE)


###################################################
### chunk number 4: 
###################################################
sum(topDiffGenes(geneList))


###################################################
### chunk number 5: 
###################################################
sampleGOdata <- new("topGOdata", 
                    description = "Simple session", ontology = "BP",
                    allGenes = geneList, geneSel = topDiffGenes,
                    nodeSize = 10,
                    annot = annFUN.db, affyLib = affyLib)


###################################################
### chunk number 6: 
###################################################
sampleGOdata


###################################################
### chunk number 7: 
###################################################
resultFisher <- runTest(sampleGOdata, algorithm = "classic", statistic = "fisher")


###################################################
### chunk number 8: 
###################################################
resultFisher


###################################################
### chunk number 9: 
###################################################
resultKS <- runTest(sampleGOdata, algorithm = "classic", statistic = "ks")
resultKS.elim <- runTest(sampleGOdata, algorithm = "elim", statistic = "ks")


###################################################
### chunk number 10: 
###################################################
allRes <- GenTable(sampleGOdata, classicFisher = resultFisher, 
                   classicKS = resultKS, elimKS = resultKS.elim,
                   orderBy = "elimKS", ranksOf = "classicFisher", topNodes = 10)


###################################################
### chunk number 11: 
###################################################
if(require(xtable))
  print(xtable(apply(allRes, 2, as.character)), floating = FALSE)


###################################################
### chunk number 12: 
###################################################
pValue.classic <- score(resultKS)
pValue.elim <- score(resultKS.elim)[names(pValue.classic)]
plot(pValue.classic, pValue.elim, xlab = "p-value classic", ylab = "p-value elim", cex = .5)


###################################################
### chunk number 13:  eval=FALSE
###################################################
## showSigOfNodes(sampleGOdata, score(resultKS.elim), firstSigNodes = 5, useInfo = 'all')


###################################################
### chunk number 14: 
###################################################
printGraph(sampleGOdata, resultKS.elim, firstSigNodes = 5, fn.prefix = "tGO", useInfo = "all", pdfSW = TRUE)


###################################################
### chunk number 15: 
###################################################
library(topGO)
library(ALL)
data(ALL)


###################################################
### chunk number 16: 
###################################################
BPterms <- ls(GOBPTerm)
head(BPterms)


###################################################
### chunk number 17: 
###################################################
library(genefilter)
selProbes <- genefilter(ALL, filterfun(pOverA(0.20, log2(100)), function(x) (IQR(x) > 0.25)))
eset <- ALL[selProbes, ]


###################################################
### chunk number 18: 
###################################################
ensembl2GO <- readMappings(file = system.file("examples/ensembl2go.map", package = "topGO"))
str(head(ensembl2GO))


###################################################
### chunk number 19: 
###################################################
GO2ensembl <- inverseList(ensembl2GO)
str(head(GO2ensembl))


###################################################
### chunk number 20: 
###################################################
geneNames <- names(ensembl2GO)
head(geneNames)


###################################################
### chunk number 21: 
###################################################
myInterestedGenes <- sample(geneNames, length(geneNames) / 10)
geneList <- factor(as.integer(geneNames %in% myInterestedGenes))
names(geneList) <- geneNames
str(geneList)


###################################################
### chunk number 22: 
###################################################
GOdata <- new("topGOdata", ontology = "MF", allGenes = geneList,
              annot = annFUN.gene2GO, gene2GO = ensembl2GO)


###################################################
### chunk number 23: 
###################################################
GOdata


###################################################
### chunk number 24: 
###################################################
y <- as.integer(sapply(eset$BT, function(x) return(substr(x, 1, 1) == 'T')))
table(y)


###################################################
### chunk number 25: 
###################################################
geneList <- getPvalues(exprs(eset), classlabel = y, alternative = "greater")


###################################################
### chunk number 26: 
###################################################
topDiffGenes <- function(allScore) {
  return(allScore < 0.01)
}
x <- topDiffGenes(geneList)
sum(x) ## the number of selected genes


###################################################
### chunk number 27: 
###################################################
GOdata <- new("topGOdata", 
              description = "GO analysis of ALL data based on diff. expression.",
              ontology = "BP",
              allGenes = geneList,
              geneSel = topDiffGenes,
              annot = annFUN.db,
              nodeSize = 5,
              affyLib = affyLib)


###################################################
### chunk number 28: 
###################################################
allProb <- featureNames(ALL)
groupProb <- integer(length(allProb)) + 1
groupProb[allProb %in% genes(GOdata)] <- 0
groupProb[!selProbes] <- 2
groupProb <- factor(groupProb, labels = c("Used", "Not annotated", "Filtered"))

tt <- table(groupProb)
tt


###################################################
### chunk number 29:  eval=FALSE
###################################################
## pValue <- getPvalues(exprs(ALL), classlabel = y, alternative = "greater")
## geneVar <- apply(exprs(ALL), 1, var)
## dd <- data.frame(x = geneVar[allProb], y = log10(pValue[allProb]), groups = groupProb)
## xyplot(y ~ x | groups, data = dd, groups = groups)


###################################################
### chunk number 30: 
###################################################
pValue <- getPvalues(exprs(ALL), classlabel = y, alternative = "greater")
geneVar <- apply(exprs(ALL), 1, var)
dd <- data.frame(x = geneVar[allProb], y = log10(pValue[allProb]), groups = groupProb)

library(lattice)
trellis.device(device = pdf, theme = col.whitebg(), file = "whichProbe.pdf", width = 9, height = 7)
legendLab <- paste(names(table(groupProb)), " (#", table(groupProb), ")", sep = "")
pP <- xyplot(y ~ x | groups, data = dd, groups = groups,
             xlab = "Variance", ylab = "Log of p-values",
             layout = c(2, 2),
             key = list(text = list(lab = legendLab),
               points = list(pch = 20, cex = 2, 
                 col = Rows(trellis.par.get("superpose.symbol"), 1:3)$col),
               size = 7, padding.text = 3,
               x = .65, y = .7, corner = c(0, 0), border = TRUE, cex = 1),
             panel = function(x, y, ...) {
               selY <- y <= -2
               panel.xyplot(x[selY], y[selY], pch = 2, ...)
               panel.xyplot(x[!selY], y[!selY], pch = 20, ...)
               panel.abline(h = -2, lty = 2, col = "black")
             })
print(pP)
dev.off()


###################################################
### chunk number 31: 
###################################################
description(GOdata)
description(GOdata) <- paste(description(GOdata), "Object modified on:", format(Sys.time(), "%d %b %Y"), sep = " ")
description(GOdata)


###################################################
### chunk number 32: 
###################################################
a <- genes(GOdata) ## obtain the list of genes
head(a)
numGenes(GOdata)


###################################################
### chunk number 33: 
###################################################
selGenes <- sample(a, 10)
gs <- geneScore(GOdata, whichGenes = selGenes) 
print(gs)


###################################################
### chunk number 34: 
###################################################
gs <- geneScore(GOdata, whichGenes = selGenes, use.names = FALSE)
print(gs)

gs <- geneScore(GOdata, use.names = FALSE)
str(gs)


###################################################
### chunk number 35: 
###################################################
sg <- sigGenes(GOdata)
str(sg)
numSigGenes(GOdata)


###################################################
### chunk number 36: 
###################################################
.geneList <- geneScore(GOdata, use.names = TRUE)
GOdata ## more available genes
GOdata <- updateGenes(GOdata, .geneList, topDiffGenes)
GOdata ## the available genes are now the feasible genes


###################################################
### chunk number 37: 
###################################################
graph(GOdata) ## returns the GO graph

ug <- usedGO(GOdata)
head(ug) 


###################################################
### chunk number 38: 
###################################################
sel.terms <- sample(usedGO(GOdata), 10)

num.ann.genes <- countGenesInTerm(GOdata, sel.terms) ## the number of annotated genes
num.ann.genes

ann.genes <- genesInTerm(GOdata, sel.terms) ## get the annotations
head(ann.genes)


###################################################
### chunk number 39: 
###################################################
ann.score <- scoresInTerm(GOdata, sel.terms)
head(ann.score)
ann.score <- scoresInTerm(GOdata, sel.terms, use.names = TRUE)
head(ann.score)


###################################################
### chunk number 40: 
###################################################
termStat(GOdata, sel.terms)


###################################################
### chunk number 41: 
###################################################
goID <- "GO:0044255"
gene.universe <- genes(GOdata)
go.genes <- genesInTerm(GOdata, goID)[[1]]
sig.genes <- sigGenes(GOdata)


###################################################
### chunk number 42: 
###################################################
my.group <- new("classicCount", testStatistic = GOFisherTest, name = "fisher",
                allMembers = gene.universe, groupMembers = go.genes,
                sigMembers = sig.genes)

contTable(my.group)
runTest(my.group)


###################################################
### chunk number 43: 
###################################################
test.stat <- new("classicCount", testStatistic = GOFisherTest, name = "Fisher test")
resultFis <- getSigGroups(GOdata, test.stat)


###################################################
### chunk number 44: 
###################################################
resultFisher


###################################################
### chunk number 45: 
###################################################
test.stat <- new("classicScore", testStatistic = GOKSTest, name = "KS tests")
resultKS <- getSigGroups(GOdata, test.stat)


###################################################
### chunk number 46: 
###################################################
test.stat <- new("elimCount", testStatistic = GOFisherTest, name = "Fisher test", cutOff = 0.01)
resultElim <- getSigGroups(GOdata, test.stat)


###################################################
### chunk number 47: 
###################################################
test.stat <- new("weightCount", testStatistic = GOFisherTest, name = "Fisher test", sigRatio = "ratio")
resultWeight <- getSigGroups(GOdata, test.stat)


###################################################
### chunk number 48: 
###################################################
resultFis <- runTest(GOdata, algorithm = "classic", statistic = "fisher")


###################################################
### chunk number 49:  eval=FALSE
###################################################
## weight01.fisher <- runTest(GOdata, statistic = "fisher")
## weight01.t <- runTest(GOdata, algorithm = "weight01", statistic = "t")
## elim.ks <- runTest(GOdata, algorithm = "elim", statistic = "ks")
## 
## weight.ks <- runTest(GOdata, algorithm = "weight", statistic = "ks") #will not work!!!


###################################################
### chunk number 50: 
###################################################
whichTests()
whichAlgorithms()


###################################################
### chunk number 51: 
###################################################
pvalFis <- score(resultFis)
head(pvalFis)
hist(pvalFis, 50, xlab = "p-values")


###################################################
### chunk number 52: 
###################################################
head(score(resultWeight))


###################################################
### chunk number 53: 
###################################################
pvalWeight <- score(resultWeight, whichGO = names(pvalFis))
head(pvalWeight)
cor(pvalFis, pvalWeight)


###################################################
### chunk number 54: 
###################################################
geneData(resultWeight)


###################################################
### chunk number 55: 
###################################################
allRes <- GenTable(GOdata, classic = resultFis, KS = resultKS, elim = resultElim,
                   weight = resultWeight, orderBy = "weight", ranksOf = "classic", topNodes = 20)


###################################################
### chunk number 56: 
###################################################
if(require(xtable))
  print(xtable(apply(allRes, 2, as.character)), floating = FALSE)


###################################################
### chunk number 57: 
###################################################
goID <- allRes[1, "GO.ID"]
print(showGroupDensity(GOdata, goID, ranks = TRUE))


###################################################
### chunk number 58: 
###################################################
goID <- allRes[10, "GO.ID"]
gt <- printGenes(GOdata, whichTerms = goID, chip = affyLib, numChar = 40)


###################################################
### chunk number 59: 
###################################################
if(require(xtable))
  print(xtable(gt), floating = FALSE)


###################################################
### chunk number 60:  eval=FALSE
###################################################
## showSigOfNodes(GOdata, score(resultFis), firstSigNodes = 5, useInfo = 'all')
## showSigOfNodes(GOdata, score(resultWeight), firstSigNodes = 5, useInfo = 'def')


###################################################
### chunk number 61: 
###################################################
printGraph(GOdata, resultFis, firstSigNodes = 5, fn.prefix = "tGO", useInfo = "all", pdfSW = TRUE)
printGraph(GOdata, resultWeight, firstSigNodes = 5, fn.prefix = "tGO", useInfo = "def", pdfSW = TRUE)


###################################################
### chunk number 62:  eval=FALSE
###################################################
## printGraph(GOdata, resultWeight, firstSigNodes = 10, resultFis, fn.prefix = "tGO", useInfo = "def")
## printGraph(GOdata, resultElim, firstSigNodes = 15, resultFis, fn.prefix = "tGO", useInfo = "all")


###################################################
### chunk number 63: 
###################################################
toLatex(sessionInfo())


