###################################################
### chunk number 1: specifyFiles
###################################################
library(ddCt)
datadir <- function(x) system.file("extdata", x, package="ddCt")
savedir <- function(x) file.path(tempdir(), x)

file.names <- c(datadir("Experiment1.txt"),datadir("Experiment2.txt"))
info <- datadir("sampleData.txt")
warningFile <- savedir("warnings.txt")


###################################################
### chunk number 2: readingData
###################################################
name.reference.sample <- c("Sample1", "Sample2")
name.reference.gene <- c("Gene2")


###################################################
### chunk number 3: readData
###################################################
library(Biobase)  
CtData <- SDMFrame(file.names)
sampleInformation <- read.AnnotatedDataFrame(info,header=TRUE, row.names=NULL)


###################################################
### chunk number 4: calculating
###################################################
result <- ddCtExpression(CtData,
                         calibrationSample=name.reference.sample,
                         housekeepingGene=name.reference.gene,
                         sampleInformation=sampleInformation,
                         warningStream=warningFile)


###################################################
### chunk number 5: showMAD
###################################################
CtErr(result)


###################################################
### chunk number 6: vis
###################################################
br <- errBarchart(result)
print(br)


###################################################
### chunk number 7: write Tables
###################################################
elistWrite(result,file=savedir("allValues.txt"))


###################################################
### chunk number 8: sessionInfo
###################################################
toLatex(sessionInfo(), locale=FALSE)


