###################################################
### chunk number 1: 
###################################################
library(affy)


###################################################
### chunk number 2: 
###################################################
bgcorrect.methods()


###################################################
### chunk number 3: 
###################################################
library(affydata)
data(Dilution) ##data included in the package for examples
normalize.methods(Dilution)


###################################################
### chunk number 4: 
###################################################
pmcorrect.methods()


###################################################
### chunk number 5: 
###################################################
express.summary.stat.methods()


###################################################
### chunk number 6: 
###################################################
eset <- mas5(Dilution)


###################################################
### chunk number 7: 
###################################################
Calls <- mas5calls(Dilution)


###################################################
### chunk number 8: 
###################################################
eset <- rma(Dilution)


###################################################
### chunk number 9: 
###################################################
Dilution


###################################################
### chunk number 10: 
###################################################
phenoData(Dilution)
pData(Dilution)


###################################################
### chunk number 11: 
###################################################
data(Dilution)
MAplot(Dilution,pairs=TRUE,plot.method="smoothScatter")


###################################################
### chunk number 12: 
###################################################
Index <- c(1,2,3,100,1000,2000) ##6 arbitrary probe positions
pm(Dilution)[Index,]
mm(Dilution)[Index,]
probeNames(Dilution)[Index]


###################################################
### chunk number 13: 
###################################################
sampleNames(Dilution)


###################################################
### chunk number 14: 
###################################################
mean(mm(Dilution)>pm(Dilution))


###################################################
### chunk number 15: 
###################################################
gn <- geneNames(Dilution)
pm(Dilution, gn[100])


###################################################
### chunk number 16: 
###################################################
hist(Dilution[,1:2]) ##PM histogram of arrays 1 and 2


###################################################
### chunk number 17:  eval=FALSE
###################################################
## par(mfrow=c(2,2))
## image(Dilution)


###################################################
### chunk number 18: 
###################################################
par(mfrow=c(1,1))
boxplot(Dilution, col=c(2,3,4))


###################################################
### chunk number 19: 
###################################################
deg <- AffyRNAdeg(Dilution)
names(deg)


###################################################
### chunk number 20: 
###################################################
summaryAffyRNAdeg(deg)


###################################################
### chunk number 21: 
###################################################
plotAffyRNAdeg(deg)


###################################################
### chunk number 22: 
###################################################
Dilution.normalized <- normalize(Dilution)


###################################################
### chunk number 23: 
###################################################
gn <- featureNames(Dilution)
ps <- probeset(Dilution, gn[1:2])
#this is what i should be using: ps
show(ps[[1]])


###################################################
### chunk number 24: 
###################################################
mylocation <- list("1000_at"=cbind(pm=c(1,2,3),mm=c(4,5,6)),
                   "1001_at"=cbind(pm=c(4,5,6),mm=c(1,2,3)))


###################################################
### chunk number 25: 
###################################################
ps <- probeset(Dilution, genenames=c("1000_at","1001_at"),
                 locations=mylocation)


###################################################
### chunk number 26: 
###################################################
pm(ps[[1]])
mm(ps[[1]])
pm(ps[[2]])
mm(ps[[2]])


###################################################
### chunk number 27: 
###################################################
data(SpikeIn) ##SpikeIn is a ProbeSets
pms <- pm(SpikeIn)
mms <- mm(SpikeIn)

##pms follow concentration
par(mfrow=c(1,2))
concentrations <- matrix(as.numeric(sampleNames(SpikeIn)),20,12,byrow=TRUE)
matplot(concentrations,pms,log="xy",main="PM",ylim=c(30,20000))
lines(concentrations[1,],apply(pms,2,mean),lwd=3)
##so do mms
matplot(concentrations,mms,log="xy",main="MM",ylim=c(30,20000))
lines(concentrations[1,],apply(mms,2,mean),lwd=3)


###################################################
### chunk number 28: 
###################################################
cat("HG_U95Av2 is",cleancdfname("HG_U95Av2"),"\n")
cat("HG-133A is",cleancdfname("HG-133A"),"\n")


###################################################
### chunk number 29: 
###################################################
cat("HG_U95Av2 is",cleancdfname("HG_U95Av2",addcdf=FALSE),"\n")


###################################################
### chunk number 30: 
###################################################
data(cdfenv.example)
ls(cdfenv.example)[1:5]
get(ls(cdfenv.example)[1],cdfenv.example)


###################################################
### chunk number 31: 
###################################################
print(Dilution@cdfName)
myenv <- getCdfInfo(Dilution)
ls(myenv)[1:5]


###################################################
### chunk number 32: 
###################################################
Index <- pmindex(Dilution)
names(Index)[1:2]
Index[1:2]


###################################################
### chunk number 33: 
###################################################
pmindex(Dilution, genenames=c("1000_at","1001_at"))


###################################################
### chunk number 34: 
###################################################
mmindex(Dilution, genenames=c("1000_at","1001_at"))


###################################################
### chunk number 35: 
###################################################
indexProbes(Dilution, which="pm")[1]
indexProbes(Dilution, which="mm")[1]
indexProbes(Dilution, which="both")[1]


###################################################
### chunk number 36: 
###################################################
opt <- getOption("BioC")
affy.opt <- opt$affy
print(names(affy.opt))


###################################################
### chunk number 37: 
###################################################
opt <- getOption("BioC")
affy.opt <- opt$affy
affy.opt$normalize.method <- "constant"
opt$affy <- affy.opt
options(BioC=opt)


###################################################
### chunk number 38: 
###################################################
opt <- getOption("BioC")
affy.opt <- opt$affy
affy.opt$compress.cel <- TRUE
opt$affy <- affy.opt
options(BioC=opt)


