###################################################
### chunk number 1: loadLibary
###################################################
library(MiChip)


###################################################
### chunk number 2: defaultRawData
###################################################
datadir <-system.file("extdata", package="MiChip")
defaultRawData <- parseRawData(datadir)


###################################################
### chunk number 3: noe
###################################################
 noEmptiesDataSet <- removeUnwantedRows(defaultRawData, c("Empty"))


###################################################
### chunk number 4: humanDataSet
###################################################
humanDataSet <- standardRemoveRows(defaultRawData)


###################################################
### chunk number 5: flagCorrectDataSet
###################################################
 flagCorrectedDataSet <- correctForFlags(humanDataSet)


###################################################
### chunk number 6: flagCorrectedDataSet
###################################################
flagCorrectedDataSet <- correctForFlags(humanDataSet, intensityCutoff = 50)


###################################################
### chunk number 7: summedData
###################################################
summedData <- summarizeIntensitiesAsMedian(flagCorrectedDataSet,minSumlength = 0, madAdjust=FALSE)


###################################################
### chunk number 8: plotIntensities
###################################################
plotIntensitiesScatter(exprs(summedData), NULL, "MiChipDemX", "SummarizedScatter")


###################################################
### chunk number 9: boxplotSummed
###################################################
 boxplotData(exprs(summedData), "MiChipDemX", "Summarized")


###################################################
### chunk number 10: mednormedData
###################################################
mednormedData <- normalizePerChipMedian(summedData)


###################################################
### chunk number 11: outputAnnot
###################################################
outputAnnotatedDataMatrix(mednormedData, "MiChipDemo", "medNormedIntensity",  "exprs")


###################################################
### chunk number 12: myNormedEset
###################################################
datadir <-system.file("extdata", package="MiChip")
 myNormedEset <- workedExampleMedianNormalize("NormedDemo", intensityCutoff = 50,datadir)


