###################################################
### chunk number 1: 
###################################################
  library(DEGseq)
  geneExpFile <- system.file("data", "GeneExpExample5000.txt", package="DEGseq")
  if(geneExpFile == ""){
     zipFile <- system.file("data", "Rdata.zip", package="DEGseq")
     if(zipFile != ""){
        unzip(zipFile, "GeneExpExample5000.txt", exdir=tempdir())
        geneExpFile <- file.path(tempdir(), "GeneExpExample5000.txt")
     }
  }


###################################################
### chunk number 2: 
###################################################
layout(matrix(c(1,2,3,4,5,6), 3, 2, byrow=TRUE))
par(mar=c(2, 2, 2, 2))
DEGexp(geneExpFile1=geneExpFile, expCol1=c(7,9,12,15,18), groupLabel1="kidney", 
       geneExpFile2=geneExpFile, expCol2=c(8,10,11,13,16), groupLabel2="liver",
       method="MARS")


###################################################
### chunk number 3: 
###################################################
layout(matrix(c(1,2,3,4,5,6), 3, 2, byrow=TRUE))
par(mar=c(2, 2, 2, 2))
DEGexp(geneExpFile1=geneExpFile, expCol1=7, groupLabel1="kidneyR1L1", 
       geneExpFile2=geneExpFile, expCol2=8, groupLabel2="liverR1L2",
       replicate1=geneExpFile, expColR1=9, replicate2=geneExpFile, expColR2=12,
       replicateLabel1="kidneyR1L3", replicateLabel2="kidneyR1L7",
       method="MATR")


###################################################
### chunk number 4: 
###################################################
  kidneyR1L1 <- system.file("data", "kidneyChr21.bed.txt", package="DEGseq")
  liverR1L2  <- system.file("data", "liverChr21.bed.txt", package="DEGseq")
  refFlat    <- system.file("data", "refFlatChr21.txt", package="DEGseq")
  mapResultBatch1 <- c(kidneyR1L1)  ## only use the data from kidneyR1L1 and liverR1L2
  mapResultBatch2 <- c(liverR1L2)
  outputDir <- file.path(tempdir(), "DEGseqExample")
  DEGseq(mapResultBatch1, mapResultBatch2, fileFormat="bed", refFlat=refFlat,
         outputDir=outputDir, method="LRT")


###################################################
### chunk number 5: 
###################################################
  geneExpFile <- system.file("data", "GeneExpExample1000.txt", package="DEGseq")
  set.seed(100)
  geneExpFile1 <- geneExpFile 
  geneExpFile2 <- geneExpFile
  output <- file.path(tempdir(), "samWrapperOut.txt")
  expCol1=c(7,9,12,15,18)
  expCol2=c(8,10,11,13,16)
  measure1=c(-1,-2,-3,-4,-5)
  measure2=c(1,2,3,4,5)
  samWrapper(geneExpFile1=geneExpFile1, geneCol1=1, expCol1=expCol1, measure1=measure1,
             geneExpFile2=geneExpFile2, geneCol2=1, expCol2=expCol2, measure2=measure2,
             nperms=100, min.foldchange=2, max.qValue=1e-4, output=output, paired=TRUE)


###################################################
### chunk number 6: 
###################################################
  kidneyR1L1 <- system.file("data", "kidneyChr21.bed.txt", package="DEGseq")
  refFlat    <- system.file("data", "refFlatChr21.txt", package="DEGseq")
  mapResultBatch <- c(kidneyR1L1)
  output <- file.path(tempdir(), "kidneyChr21.bed.exp")
  getGeneExp(mapResultBatch, refFlat=refFlat, output=output)
  exp <-readGeneExp(file=output, geneCol=1, valCol=c(2,3), label=c("raw count", "RPKM"))
  exp[30:32,]


###################################################
### chunk number 7: 
###################################################
  geneExpFile <- system.file("data", "GeneExpExample1000.txt", package="DEGseq")
  exp <- readGeneExp(file=geneExpFile, geneCol=1, valCol=c(7,9,12,15,18,8,10,11,13,16))
  exp[30:32,]


