/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import weka.core.Attribute;
import weka.core.Copyable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.C45Loader;
import weka.core.converters.CSVLoader;
import weka.core.converters.Loader;
import weka.experiment.InstanceQuery;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.AttributeSelectionPanel;
import weka.gui.AttributeSummaryPanel;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.ViewerDialog;
import weka.gui.beans.AttributeSummarizer;

public class PreprocessPanel
extends JPanel {
    protected InstancesSummaryPanel m_InstSummaryPanel = new InstancesSummaryPanel();
    protected JButton m_OpenFileBut = new JButton("Open file...");
    protected JButton m_OpenURLBut = new JButton("Open URL...");
    protected JButton m_OpenDBBut = new JButton("Open DB...");
    protected GenericObjectEditor m_DatabaseQueryEditor = new GenericObjectEditor();
    protected JButton m_UndoBut = new JButton("Undo");
    protected JButton m_EditBut = new JButton("Edit...");
    protected JButton m_SaveBut = new JButton("Save...");
    protected AttributeSelectionPanel m_AttPanel = new AttributeSelectionPanel();
    JButton m_RemoveButton = new JButton("Remove");
    protected AttributeSummaryPanel m_AttSummaryPanel = new AttributeSummaryPanel();
    protected GenericObjectEditor m_FilterEditor = new GenericObjectEditor();
    protected PropertyPanel m_FilterPanel = new PropertyPanel(this.m_FilterEditor);
    protected JButton m_ApplyFilterBut = new JButton("Apply");
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected ExtensionFileFilter m_bsiFileFilter = new ExtensionFileFilter(Instances.SERIALIZED_OBJ_FILE_EXTENSION, "Binary serialized instances");
    protected ExtensionFileFilter m_c45FileFilter = new ExtensionFileFilter(C45Loader.FILE_EXTENSION, "C45 names files");
    protected ExtensionFileFilter m_csvFileFilter = new ExtensionFileFilter(CSVLoader.FILE_EXTENSION, "CSV data files");
    protected ExtensionFileFilter m_arffFileFilter = new ExtensionFileFilter(Instances.FILE_EXTENSION, "Arff data files");
    protected String m_LastURL = "http://";
    protected String m_SQLQ = new String("SELECT * FROM ?");
    protected Instances m_Instances;
    protected AttributeVisualizationPanel m_AttVisualizePanel = new AttributeVisualizationPanel();
    protected File[] m_tempUndoFiles = new File[20];
    protected int m_tempUndoIndex = 0;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Thread m_IOThread;
    protected Logger m_Log = new SysErrLog();

    public PreprocessPanel() {
        try {
            this.m_DatabaseQueryEditor.setClassType(InstanceQuery.class);
            this.m_DatabaseQueryEditor.setValue(new InstanceQuery());
            ((GenericObjectEditor.GOEPanel)this.m_DatabaseQueryEditor.getCustomEditor()).addOkListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreprocessPanel.this.setInstancesFromDBQ();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_FilterEditor.setClassType(Filter.class);
        this.m_OpenFileBut.setToolTipText("Open a set of instances from a file");
        this.m_OpenURLBut.setToolTipText("Open a set of instances from a URL");
        this.m_OpenDBBut.setToolTipText("Open a set of instances from a database");
        this.m_UndoBut.setToolTipText("Undo the last change to the dataset");
        this.m_EditBut.setToolTipText("Open the current dataset in a Viewer for editing");
        this.m_SaveBut.setToolTipText("Save the working relation to a file");
        this.m_ApplyFilterBut.setToolTipText("Apply the current filter to the data");
        this.m_FileChooser.addChoosableFileFilter(this.m_bsiFileFilter);
        this.m_FileChooser.addChoosableFileFilter(this.m_c45FileFilter);
        this.m_FileChooser.addChoosableFileFilter(this.m_csvFileFilter);
        this.m_FileChooser.addChoosableFileFilter(this.m_arffFileFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_OpenURLBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.setInstancesFromURLQ();
            }
        });
        this.m_OpenDBBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog propertyDialog = new PropertyDialog(PreprocessPanel.this.m_DatabaseQueryEditor, 100, 100);
            }
        });
        this.m_OpenFileBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.setInstancesFromFileQ();
            }
        });
        this.m_UndoBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.undo();
            }
        });
        this.m_EditBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.edit();
            }
        });
        this.m_SaveBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.saveWorkingInstancesToFileQ();
            }
        });
        this.m_ApplyFilterBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreprocessPanel.this.applyFilter((Filter)PreprocessPanel.this.m_FilterEditor.getValue());
            }
        });
        this.m_AttPanel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        PreprocessPanel.this.m_AttSummaryPanel.setAttribute(i);
                        PreprocessPanel.this.m_AttVisualizePanel.setAttribute(i);
                        break;
                    }
                }
            }
        });
        this.m_InstSummaryPanel.setBorder(BorderFactory.createTitledBorder("Current relation"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Attributes"));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_AttPanel, "Center");
        this.m_RemoveButton.setEnabled(false);
        this.m_RemoveButton.setToolTipText("Remove selected attributes.");
        this.m_RemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Remove remove = new Remove();
                    int[] nArray = PreprocessPanel.this.m_AttPanel.getSelectedAttributes();
                    if (nArray.length == 0) {
                        return;
                    }
                    if (nArray.length == PreprocessPanel.this.m_Instances.numAttributes()) {
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Can't remove all attributes from data!\n", "Remove Attributes", 0);
                        PreprocessPanel.this.m_Log.logMessage("Can't remove all attributes from data!");
                        PreprocessPanel.this.m_Log.statusMessage("Problem removing attributes");
                        return;
                    }
                    remove.setAttributeIndicesArray(nArray);
                    PreprocessPanel.this.applyFilter(remove);
                }
                catch (Exception exception) {
                    if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                        ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                    }
                    JOptionPane.showMessageDialog(PreprocessPanel.this, "Problem filtering instances:\n" + exception.getMessage(), "Remove Attributes", 0);
                    PreprocessPanel.this.m_Log.logMessage("Problem removing attributes: " + exception.getMessage());
                    PreprocessPanel.this.m_Log.statusMessage("Problem removing attributes");
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.m_RemoveButton, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.m_AttSummaryPanel.setBorder(BorderFactory.createTitledBorder("Selected attribute"));
        this.m_UndoBut.setEnabled(false);
        this.m_EditBut.setEnabled(false);
        this.m_SaveBut.setEnabled(false);
        this.m_ApplyFilterBut.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel3.setLayout(new GridLayout(1, 6, 5, 5));
        jPanel3.add(this.m_OpenFileBut);
        jPanel3.add(this.m_OpenURLBut);
        jPanel3.add(this.m_OpenDBBut);
        jPanel3.add(this.m_UndoBut);
        jPanel3.add(this.m_EditBut);
        jPanel3.add(this.m_SaveBut);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Filter"));
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.m_FilterPanel, "Center");
        jPanel5.add((Component)this.m_ApplyFilterBut, "East");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(2, 1));
        jPanel6.add(this.m_AttSummaryPanel);
        JComboBox jComboBox = this.m_AttVisualizePanel.getColorBox();
        jComboBox.setToolTipText("The chosen attribute will also be used as the class attribute when a filter is applied.");
        final JButton jButton = new JButton("Visualize All");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PreprocessPanel.this.m_Instances != null) {
                    try {
                        AttributeSummarizer attributeSummarizer = new AttributeSummarizer();
                        attributeSummarizer.setColoringIndex(PreprocessPanel.this.m_AttVisualizePanel.getColoringIndex());
                        attributeSummarizer.setInstances(PreprocessPanel.this.m_Instances);
                        final JFrame jFrame = new JFrame();
                        jFrame.getContentPane().setLayout(new BorderLayout());
                        jFrame.getContentPane().add((Component)attributeSummarizer, "Center");
                        jFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent windowEvent) {
                                jButton.setEnabled(true);
                                jFrame.dispose();
                            }
                        });
                        jFrame.setSize(830, 600);
                        jFrame.setVisible(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)this.m_AttVisualizePanel, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)jComboBox, "Center");
        jPanel8.add((Component)jButton, "East");
        jPanel7.add((Component)jPanel8, "North");
        jPanel6.add(jPanel7);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)this.m_InstSummaryPanel, "North");
        jPanel9.add((Component)jPanel4, "Center");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.add((Component)jPanel6, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayout(1, 2));
        jPanel11.add(jPanel9);
        jPanel11.add(jPanel10);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.add((Component)jPanel5, "North");
        jPanel12.add((Component)jPanel11, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "North");
        this.add((Component)jPanel12, "Center");
    }

    public void setLog(Logger logger) {
        this.m_Log = logger;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    PreprocessPanel.this.m_InstSummaryPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_RemoveButton.setEnabled(true);
                    PreprocessPanel.this.m_AttSummaryPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttVisualizePanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttPanel.getSelectionModel().setSelectionInterval(0, 0);
                    PreprocessPanel.this.m_AttSummaryPanel.setAttribute(0);
                    PreprocessPanel.this.m_AttVisualizePanel.setAttribute(0);
                    PreprocessPanel.this.m_ApplyFilterBut.setEnabled(true);
                    PreprocessPanel.this.m_Log.logMessage("Base relation is now " + PreprocessPanel.this.m_Instances.relationName() + " (" + PreprocessPanel.this.m_Instances.numInstances() + " instances)");
                    PreprocessPanel.this.m_SaveBut.setEnabled(true);
                    PreprocessPanel.this.m_EditBut.setEnabled(true);
                    PreprocessPanel.this.m_Log.statusMessage("OK");
                    PreprocessPanel.this.m_Support.firePropertyChange("", null, null);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Problem setting base instances:\n" + exception, "Instances", 0);
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void applyFilter(final Filter filter) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        if (filter != null) {
                            if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskStarted();
                            }
                            PreprocessPanel.this.m_Log.statusMessage("Passing dataset through filter " + filter.getClass().getName());
                            int n = PreprocessPanel.this.m_AttVisualizePanel.getColoringIndex();
                            if (n < 0 && filter instanceof SupervisedFilter) {
                                throw new IllegalArgumentException("Class (colour) needs to be set for supervised filter.");
                            }
                            Instances instances = new Instances(PreprocessPanel.this.m_Instances);
                            instances.setClassIndex(n);
                            filter.setInputFormat(instances);
                            Instances instances2 = Filter.useFilter(instances, filter);
                            if (instances2 == null || instances2.numAttributes() < 1) {
                                throw new Exception("Dataset is empty.");
                            }
                            PreprocessPanel.this.m_Log.statusMessage("Saving undo information");
                            PreprocessPanel.this.addUndoPoint();
                            PreprocessPanel.this.m_AttVisualizePanel.setColoringIndex(instances.classIndex());
                            if (PreprocessPanel.this.m_Instances.classIndex() < 0) {
                                instances2.setClassIndex(-1);
                            }
                            PreprocessPanel.this.m_Instances = instances2;
                            PreprocessPanel.this.setInstances(PreprocessPanel.this.m_Instances);
                            if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                        }
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Problem filtering instances:\n" + exception.getMessage(), "Apply Filter", 0);
                        PreprocessPanel.this.m_Log.logMessage("Problem filtering instances: " + exception.getMessage());
                        PreprocessPanel.this.m_Log.statusMessage("Problem filtering instances");
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't apply filter at this time,\ncurrently busy with other IO", "Apply Filter", 2);
        }
    }

    public void saveWorkingInstancesToFileQ() {
        if (this.m_IOThread == null) {
            Object object;
            this.m_FileChooser.setAcceptAllFileFilterUsed(false);
            int n = this.m_FileChooser.showSaveDialog(this);
            if (n == 0) {
                object = this.m_FileChooser.getSelectedFile();
                if (this.m_FileChooser.getFileFilter() == this.m_arffFileFilter) {
                    if (!((File)object).getName().toLowerCase().endsWith(Instances.FILE_EXTENSION)) {
                        object = new File(((File)object).getParent(), ((File)object).getName() + Instances.FILE_EXTENSION);
                    }
                    Object object2 = object;
                    this.saveInstancesToFile((File)object2, this.m_Instances, true);
                } else if (this.m_FileChooser.getFileFilter() == this.m_csvFileFilter) {
                    if (!((File)object).getName().toLowerCase().endsWith(CSVLoader.FILE_EXTENSION)) {
                        object = new File(((File)object).getParent(), ((File)object).getName() + CSVLoader.FILE_EXTENSION);
                    }
                    Object object3 = object;
                    this.saveInstancesToFile((File)object3, this.m_Instances, false);
                } else if (this.m_FileChooser.getFileFilter() == this.m_c45FileFilter) {
                    Object object4 = object;
                    this.saveInstancesToC45File((File)object4, this.m_Instances);
                } else if (this.m_FileChooser.getFileFilter() == this.m_bsiFileFilter) {
                    if (!((File)object).getName().toLowerCase().endsWith(Instances.SERIALIZED_OBJ_FILE_EXTENSION)) {
                        object = new File(((File)object).getParent(), ((File)object).getName() + Instances.SERIALIZED_OBJ_FILE_EXTENSION);
                    }
                    Object object5 = object;
                    this.saveSerializedInstancesToFile((File)object5, this.m_Instances);
                }
            }
            object = this.m_FileChooser.getFileFilter();
            this.m_FileChooser.setAcceptAllFileFilterUsed(true);
            this.m_FileChooser.setFileFilter((FileFilter)object);
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Save Instances", 2);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int n = this.m_FileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = this.m_FileChooser.getSelectedFile();
                try {
                    this.addUndoPoint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setInstancesFromFile(file);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromDBQ() {
        if (this.m_IOThread == null) {
            try {
                InstanceQuery instanceQuery = (InstanceQuery)this.m_DatabaseQueryEditor.getValue();
                if (instanceQuery.isConnected()) {
                    instanceQuery.disconnectFromDatabase();
                }
                instanceQuery.connectToDatabase();
                try {
                    this.addUndoPoint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setInstancesFromDB(instanceQuery);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Problem connecting to database:\n" + exception.getMessage(), "Load Instances", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURLQ() {
        block6: {
            if (this.m_IOThread == null) {
                try {
                    String string = (String)JOptionPane.showInputDialog(this, "Enter the source URL", "Load Instances", 3, null, null, this.m_LastURL);
                    if (string == null) break block6;
                    this.m_LastURL = string;
                    URL uRL = new URL(string);
                    try {
                        this.addUndoPoint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setInstancesFromURL(uRL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Problem with URL:\n" + exception.getMessage(), "Load Instances", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
            }
        }
    }

    protected void saveInstancesToC45File(final File file, final Instances instances) {
        if (this.m_IOThread == null) {
            final int n = this.m_AttVisualizePanel.getColoringIndex();
            if (instances.attribute(n).isNumeric()) {
                JOptionPane.showMessageDialog(this, "Can't save in C45 format,\nas the selected class is numeric.", "Save Instances", 0);
                return;
            }
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        int n3;
                        Copyable copyable;
                        int n2;
                        PreprocessPanel.this.m_Log.statusMessage("Saving to file...");
                        String string = file.getAbsolutePath();
                        if (string.lastIndexOf(46) != -1) {
                            string = string.substring(0, string.lastIndexOf(46));
                        }
                        File file3 = new File(string + ".data");
                        File file2 = new File(string + ".names");
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                        BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file3));
                        for (n2 = 0; n2 < instances.attribute(n).numValues(); ++n2) {
                            bufferedWriter.write(instances.attribute(n).value(n2));
                            if (n2 < instances.attribute(n).numValues() - 1) {
                                bufferedWriter.write(",");
                                continue;
                            }
                            bufferedWriter.write(".\n");
                        }
                        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                            if (n2 == n) continue;
                            bufferedWriter.write(instances.attribute(n2).name() + ": ");
                            if (instances.attribute(n2).isNumeric() || instances.attribute(n2).isDate()) {
                                bufferedWriter.write("continuous.\n");
                                continue;
                            }
                            copyable = instances.attribute(n2);
                            for (n3 = 0; n3 < ((Attribute)copyable).numValues(); ++n3) {
                                bufferedWriter.write(((Attribute)copyable).value(n3));
                                if (n3 < ((Attribute)copyable).numValues() - 1) {
                                    bufferedWriter.write(",");
                                    continue;
                                }
                                bufferedWriter.write(".\n");
                            }
                        }
                        ((Writer)bufferedWriter).close();
                        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                            copyable = instances.instance(n2);
                            for (n3 = 0; n3 < instances.numAttributes(); ++n3) {
                                if (n3 == n) continue;
                                if (((Instance)copyable).isMissing(n3)) {
                                    bufferedWriter2.write("?,");
                                    continue;
                                }
                                if (instances.attribute(n3).isNominal() || instances.attribute(n3).isString()) {
                                    bufferedWriter2.write(instances.attribute(n3).value((int)((Instance)copyable).value(n3)) + ",");
                                    continue;
                                }
                                bufferedWriter2.write("" + ((Instance)copyable).value(n3) + ",");
                            }
                            if (((Instance)copyable).isMissing(n)) {
                                bufferedWriter2.write("?");
                            } else {
                                bufferedWriter2.write(instances.attribute(n).value((int)((Instance)copyable).value(n)));
                            }
                            bufferedWriter2.write("\n");
                        }
                        ((Writer)bufferedWriter2).close();
                        PreprocessPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(exception.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Save c45 format", 2);
        }
    }

    protected void saveSerializedInstancesToFile(final File file, final Instances instances) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Saving to file...");
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                        objectOutputStream.writeObject(instances);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                        PreprocessPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(exception.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Save binary serialized instances", 2);
        }
    }

    protected void saveInstancesToFile(final File file, final Instances instances, final boolean bl) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Saving to file...");
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        if (bl) {
                            Instances instances2 = new Instances(instances, 0);
                            bufferedWriter.write(instances2.toString());
                            bufferedWriter.write("\n");
                        } else {
                            for (int i = 0; i < instances.numAttributes(); ++i) {
                                bufferedWriter.write(instances.attribute(i).name());
                                if (i >= instances.numAttributes() - 1) continue;
                                bufferedWriter.write(",");
                            }
                            bufferedWriter.write("\n");
                        }
                        for (int i = 0; i < instances.numInstances(); ++i) {
                            bufferedWriter.write(instances.instance(i).toString());
                            bufferedWriter.write("\n");
                        }
                        ((Writer)bufferedWriter).close();
                        PreprocessPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(exception.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Save Instances", 2);
        }
    }

    private void converterQuery(final File file) {
        final GenericObjectEditor genericObjectEditor = new GenericObjectEditor(true);
        try {
            genericObjectEditor.setClassType(Loader.class);
            genericObjectEditor.setValue(new CSVLoader());
            ((GenericObjectEditor.GOEPanel)genericObjectEditor.getCustomEditor()).addOkListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreprocessPanel.this.tryConverter((Loader)genericObjectEditor.getValue(), file);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        PropertyDialog propertyDialog = new PropertyDialog(genericObjectEditor, 100, 100);
    }

    private void tryConverter(final Loader loader, final File file) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        loader.setSource(file);
                        Instances instances = loader.getDataSet();
                        PreprocessPanel.this.setInstances(instances);
                    }
                    catch (Exception exception) {
                        PreprocessPanel.this.m_Log.statusMessage(loader.getClass().getName() + " failed to load " + file.getName());
                        JOptionPane.showMessageDialog(PreprocessPanel.this, loader.getClass().getName() + " failed to load '" + file.getName() + "'.\n" + "Reason:\n" + exception.getMessage(), "Convert File", 0);
                        PreprocessPanel.this.m_IOThread = null;
                        PreprocessPanel.this.converterQuery(file);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        }
    }

    public void setInstancesFromFile(final File file) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    block6: {
                        String string = file.getName();
                        try {
                            PreprocessPanel.this.m_Log.statusMessage("Reading from file...");
                            if (file.getName().toLowerCase().endsWith(Instances.FILE_EXTENSION)) {
                                string = "arff";
                                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                                PreprocessPanel.this.setInstances(new Instances(bufferedReader));
                                ((Reader)bufferedReader).close();
                                break block6;
                            }
                            if (file.getName().toLowerCase().endsWith(CSVLoader.FILE_EXTENSION)) {
                                string = "csv";
                                CSVLoader cSVLoader = new CSVLoader();
                                cSVLoader.setSource(file);
                                Instances instances = cSVLoader.getDataSet();
                                PreprocessPanel.this.setInstances(instances);
                                break block6;
                            }
                            if (file.getName().toLowerCase().endsWith(C45Loader.FILE_EXTENSION)) {
                                string = "C45 names";
                                C45Loader c45Loader = new C45Loader();
                                c45Loader.setSource(file);
                                Instances instances = c45Loader.getDataSet();
                                PreprocessPanel.this.setInstances(instances);
                                break block6;
                            }
                            if (file.getName().toLowerCase().endsWith(Instances.SERIALIZED_OBJ_FILE_EXTENSION) || file.getName().toLowerCase().endsWith(".tmp")) {
                                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                                PreprocessPanel.this.setInstances((Instances)objectInputStream.readObject());
                                objectInputStream.close();
                                break block6;
                            }
                            throw new Exception("Unrecognized file type");
                        }
                        catch (Exception exception) {
                            PreprocessPanel.this.m_Log.statusMessage("File '" + file.getName() + "' not recognised as an " + string + " file.");
                            PreprocessPanel.this.m_IOThread = null;
                            if (JOptionPane.showOptionDialog(PreprocessPanel.this, "File '" + file.getName() + "' not recognised as an " + string + " file.\n" + "Reason:\n" + exception.getMessage(), "Load Instances", 0, 0, null, new String[]{"OK", "Use Converter"}, null) != 1) break block6;
                            PreprocessPanel.this.converterQuery(file);
                        }
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromDB(final InstanceQuery instanceQuery) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Reading from database...");
                        final Instances instances = instanceQuery.retrieveInstances();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                PreprocessPanel.this.setInstances(new Instances(instances));
                            }
                        });
                        instanceQuery.disconnectFromDatabase();
                    }
                    catch (Exception exception) {
                        PreprocessPanel.this.m_Log.statusMessage("Problem executing DB query " + PreprocessPanel.this.m_SQLQ);
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Couldn't read from database:\n" + exception.getMessage(), "Load Instances", 0);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURL(final URL uRL) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        PreprocessPanel.this.m_Log.statusMessage("Reading from URL...");
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                        PreprocessPanel.this.setInstances(new Instances(bufferedReader));
                        ((Reader)bufferedReader).close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        PreprocessPanel.this.m_Log.statusMessage("Problem reading " + uRL);
                        JOptionPane.showMessageDialog(PreprocessPanel.this, "Couldn't read from URL:\n" + uRL + "\n" + exception.getMessage(), "Load Instances", 0);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void addUndoPoint() throws Exception {
        if (this.m_Instances != null) {
            File file = File.createTempFile("weka", null);
            file.deleteOnExit();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(this.m_Instances);
            objectOutputStream.flush();
            objectOutputStream.close();
            if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
                this.m_tempUndoFiles[this.m_tempUndoIndex].delete();
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = file;
            if (++this.m_tempUndoIndex >= this.m_tempUndoFiles.length) {
                this.m_tempUndoIndex = 0;
            }
            this.m_UndoBut.setEnabled(true);
        }
    }

    public void undo() {
        int n;
        if (--this.m_tempUndoIndex < 0) {
            this.m_tempUndoIndex = this.m_tempUndoFiles.length - 1;
        }
        if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
            this.setInstancesFromFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
            this.m_tempUndoFiles[this.m_tempUndoIndex] = null;
        }
        if ((n = this.m_tempUndoIndex - 1) < 0) {
            n = this.m_tempUndoFiles.length - 1;
        }
        this.m_UndoBut.setEnabled(this.m_tempUndoFiles[n] != null);
    }

    public void edit() {
        int n = this.m_AttVisualizePanel.getColoringIndex();
        Instances instances = new Instances(this.m_Instances);
        instances.setClassIndex(n);
        ViewerDialog viewerDialog = new ViewerDialog(null);
        int n2 = viewerDialog.showDialog(instances);
        if (n2 == 0) {
            try {
                this.addUndoPoint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Instances instances2 = viewerDialog.getInstances();
            if (this.m_Instances.classIndex() < 0) {
                instances2.setClassIndex(-1);
            }
            this.setInstances(instances2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Weka Explorer: Preprocess");
            jFrame.getContentPane().setLayout(new BorderLayout());
            PreprocessPanel preprocessPanel = new PreprocessPanel();
            jFrame.getContentPane().add((Component)preprocessPanel, "Center");
            LogPanel logPanel = new LogPanel();
            preprocessPanel.setLog(logPanel);
            jFrame.getContentPane().add((Component)logPanel, "South");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

