### Name: twilight.pval
### Title: A function to compute p-values from expression sets
### Aliases: twilight.pval
### Keywords: nonparametric

### ** Examples

### Leukemia data set of Golub et al. (1999)
library(golubEsets)
data(golubMerge)

### Variance-stabilizing normalization of Huber et al. (2002)
library(vsn)
golubNorm <- vsn(exprs(golubMerge))

### A vector of class labels.
id <- as.numeric(golubMerge$ALL.AML)

a <- twilight.pval(golubNorm,id)
plot(a,which="scores")
plot(a,which="qvalues")



