### Name: stam.fit
### Title: Fit StAM Model to Training Data
### Aliases: stam.fit
### Keywords: classif

### ** Examples

## Don't show: 
  library(vsn)
  library(golubEsets)
  data(golubMerge)
  golubNorm <- vsn(golubMerge, describe.preprocessing=FALSE)
## End Don't show
# load and prepare some data
golubTrain <- golubNorm[,1:38]
data(golubTrain.cv)

# compute fit
golubTrain.fit <- stam.fit(golubTrain.cv, golubTrain, alpha=seq(0, 1, 0.1))

# investigate
print(golubTrain.fit)
plot(golubTrain.fit)

# show clickable web-page
## Not run: 
##D map <- stam.graph.plot(golubTrain.fit, outfile="golubTrain")
##D cat("<HTML><BODY><MAP NAME='graph_map'>", map, "</MAP>",
##D     "<IMG SRC='golubTrain_graph_plot.png' USEMAP='#graph_map'></BODY></HTML>\n", 
##D     file="graph_plot.html")
##D browseURL(paste("file://", getwd(), "/graph_plot.html", sep=""))
## End(Not run)


