### Name: stam.cv
### Title: Cross Validated Training for StAM
### Aliases: stam.cv
### Keywords: classif

### ** Examples

# load and prepare some data
library(vsn)
library(golubEsets)
data(golubMerge)
golubNorm <- vsn(golubMerge, describe.preprocessing=FALSE)
golubTrain <- golubNorm[,1:38]

# classify into ALL and AML
# (root is chosen to yield results reasonably fast, 
#  consider GO:0008150 (biological process) to obtain 
#  meaningful results)
golubTrain.cv <- stam.cv(golubTrain, "ALL.AML", chip="hu6800",
                         root="GO:0005576", ndeltas=10)

# get further information
print(golubTrain.cv)
plot(golubTrain.cv, delta=0.6)



