### Name: topgenes
### Title: Topgenes, returns a list of variables at the ends (positive,
###   negative or both) of an axis
### Aliases: topgenes
### Keywords: manip

### ** Examples


# Simple example
a<-rnorm(50)
order(a)
topgenes(a, labels=c(1:length(a)), ends="neg")

# Applied example
data(khan)
if (require(ade4, quiet = TRUE)) {
khan.coa<-dudi.coa(khan$train[1:100,1:10], scannf=FALSE, nf=2)
}
ind<-topgenes(khan.coa$li, ends="pos")
ind.ID<-topgenes(khan.coa$li, ends="pos", labels=khan$gene.labels.imagesID)
ind.symbol<-topgenes(khan.coa$li, ends="pos", labels=khan$annotation$Symbol)
Top10.pos<- cbind("Gene Symbol"=ind.symbol, 
      "Clone ID"=ind.ID, "Coordinates"=khan.coa$li[ind,], row.names=c(1:length(ind)))
Top10.pos



