### Name: evalScoring
### Title: Score differential expression, assess significance, and smooth
###   scores along the chromosome
### Aliases: evalScoring
### Keywords: manip

### ** Examples

   
    #loaddatapkg("stjudem")
    data(stjd)

    # T-lymphocyte versus B-lymphocyte on chromosome 1, 
    #  smoothed with k-Nearest-Neighbours kernel(k=15), 
    #  few permutations for higher speed
    chrom1Tknn <- evalScoring(stjd,"T",chromosome="1",permute="labels",
    nperms=100,kernel=kNN,kernelparams=list(k=15),step.width=100000)

    # plotting on x11:
    plot(chrom1Tknn)

    # plotting on HTML:
    plot(chrom1Tknn,"html")



