### Name: updateDFBySpread
### Title: Determines values needed to initialize a gUpdateDataMessage
###   object if the current view is a spreadsheet
### Aliases: updateDFBySpread
### Keywords: manip

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # creating a spreadsheet should occur through View Data under
    # the Display menu
    createView(type = "spreadView", dataName = "USArrests")
    # should set highlight mode using the Highlight menu item under ViewMode
    setHighlightMode()
    # now click on a row of the spreadsheet
    # this will cause updateDF and updateDFBySpread to be called
    # you can tell it was called because the data for that row will now
    # have highlit set to TRUE  
  }



