### Name: setDeleteEvents
### Title: Set up the proper events when a gtk window is deleted
### Aliases: setDeleteEvents
### Keywords: data

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # plotting the data should occur through Plot Data under 
    # the Display menu
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2)  
    # now check viewList in viewEnv, as well as R's device list
    get("viewList",viewEnv)
    dev.list()

    # now close the gtk window that has the scatterplot in it
    # closing the window will cause setDeleteEvents to be called

    # then check again viewList in viewEnv, as well as 
    # R's device list - all should have removed the window and device info 
    get("viewList",viewEnv)      
    dev.list()
  }



