### Name: replot
### Title: Redraw a plot because data has changed
### Aliases: replot
### Keywords: iplot

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # plotting the data should occur through Plot Data under 
    # the Display menu
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2) 
    # should modify using the control window (by choosing the view mode and
    # then clicking on a plot)
    # by interacting with a plot when the view mode is color, these 
    # functions will be called automatically
    modify("USArrests", Rname=c("Massachusetts","Ohio"), 
           Cname=c("color","color"), data=c("red","green"))
    # updateViews will create a gUpdateViewMessage and call the 
    # handleMessage method, which will call updatePoints because the 
    # type is modify
    updateViews(dfName="USArrests", type="modify", 
                rowName=c("Massachusetts","Ohio"))

    # should perform reset using Reset under the Edit menu 
    reset("USArrests")
    # updateViews will create a gUpdateViewMessage and call the 
    # handleMessage method, which will call replot because the 
    # type is reset
    updateViews(dfName="USArrests",type="reset")
  }



