### Name: gUpdateViewMessage-class
### Title: Class "gUpdateViewMessage": A class to represent an update view
###   message
### Aliases: gUpdateViewMessage-class gUpdateViewMessage
###   handleMessage,gUpdateViewMessage-method
###   initialize,gUpdateViewMessage-method
### Keywords: classes

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # plotting the data should occur through Plot Data under the 
    # Display menu
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2)    
    # should modify using the control window (by choosing the view mode and
    # then clicking on a plot)
    # by interacting with a plot when the view mode is color, these 
    # functions will be called automatically
    modify("USArrests", Rname=c("Massachusetts","Ohio"), 
           Cname=c("color","color"), data=c("red","green")) 
    # create an update view message and then dispatch it so the points
    # that have changed will be replot
    plMessage<-new("gUpdateViewMessage",type="modify",Rname=c("Massachusetts",
                   "Ohio"))
    handleMessage(plMessage,dataName="USArrests")

    # now see if the message is inherited from gMessage
    is(plMessage,"gUpdateViewMessage")
  }



