### Name: clusterVisualHclust-class
### Title: Class "clusterVisualHclust" prepares a visualization for a
###   dataset that has been clustered with hierarchical clustering.
### Aliases: clusterVisualHclust-class display,clusterVisualHclust-method
###   print,clusterVisualHclust-method config,clusterVisualHclust-method
###   execute,clusterVisualHclust-method reset,clusterVisualHclust-method
###   setup<-,clusterVisualHclust-method setup,clusterVisualHclust-method
### Keywords: classes

### ** Examples


set.seed(1000)

data(benomylsetupsmall)

benomylsetupsmall$classalgo <- "clusterAlgorithmHclust"
benomylsetupsmall$algo$method   <- "complete"
benomylsetupsmall$algo$distance <- "euclidean"

benomylsetupsmall$classvisu <- "clusterVisualHclust"

a <- new("goCluster")

execute(a) <- benomylsetupsmall

if(interactive()){
## This example can only be run in an interactive mode

## This plot shows only one labeled region since the 
## loaded dataset has been reduced to only 100 genes. 
## Try the same with the full dataset
display(a, selection = 1)
}




