### Name: mergeSAGE
### Title: Functions to merge SAGE libraries based on unique SAGE tags
### Aliases: mergeSAGE getLibInfo calNormFact getLibNNum getUniqTags
###   writeSAGE4Win writeSAGE4Unix mapFile2Tag writeSAGECounts writeSAGE2DB
###   getColSQL
### Keywords: manip

### ** Examples

path <- tempdir()
# Create two libraries
lib1 <- cbind(paste("tag", 1:10, sep = ""), 1:10)
lib2 <- cbind(paste("tag", 5:9, sep = ""), 15:19)
write.table(lib1, file = file.path(path, "lib1.sage"), sep = "\t",
row.names = FALSE, col.names = FALSE)
write.table(lib2, file = file.path(path, "lib2.sage"), sep = "\t",
row.names = FALSE, col.names = FALSE) 
libNNum <- getLibNNum(c(file.path(path, "lib1.sage"),
file.path(path, "lib2.sage")))
normFact <- calNormFact("min", libNNum)
uniqTag <- getUniqTags(c(file.path(path, "lib1.sage"),
file.path(path, "lib2.sage")), skip = 0)



