/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.runtime.output.OutputBase;
import org.apache.xalan.xsltc.runtime.output.OutputBuffer;

public abstract class StreamOutput
extends OutputBase {
    protected static final String AMP = "&amp;";
    protected static final String LT = "&lt;";
    protected static final String GT = "&gt;";
    protected static final String CRLF = "&#xA;";
    protected static final String APOS = "&apos;";
    protected static final String QUOT = "&quot;";
    protected static final String NBSP = "&nbsp;";
    protected static final String CHAR_ESC_START = "&#";
    protected static final char[] INDENT = "                    ".toCharArray();
    protected static final int MAX_INDENT_LEVEL = INDENT.length >> 1;
    protected static final int MAX_INDENT = INDENT.length;
    protected Writer _writer;
    protected OutputBuffer _buffer;
    protected boolean _is8859Encoded = false;
    protected boolean _indent = false;
    protected boolean _omitHeader = false;
    protected String _standalone = null;
    protected String _version = "1.0";
    protected boolean _lineFeedNextStartTag = false;
    protected boolean _linefeedNextEndTag = false;
    protected boolean _indentNextEndTag = false;
    protected int _indentLevel = 0;
    protected boolean _escaping = true;
    protected String _encoding = "UTF-8";
    protected int _indentNumber = 2;
    protected Vector _attributes = new Vector();
    private static Hashtable _canonicalEncodings = new Hashtable();

    public static String getCanonicalEncoding(String encoding) {
        String canonical = (String)_canonicalEncodings.get(encoding.toLowerCase());
        return canonical != null ? canonical : encoding;
    }

    protected StreamOutput(StreamOutput output) {
        this._writer = output._writer;
        this._encoding = output._encoding;
        this._is8859Encoded = output._is8859Encoded;
        this._buffer = output._buffer;
        this._indentNumber = output._indentNumber;
    }

    protected StreamOutput(Writer writer, String encoding) {
        this._writer = writer;
        this._encoding = encoding;
        this._is8859Encoded = encoding.equalsIgnoreCase("iso-8859-1");
    }

    protected StreamOutput(OutputStream out, String encoding) throws IOException {
        try {
            this._writer = new OutputStreamWriter(out, StreamOutput.getCanonicalEncoding(encoding));
            this._encoding = encoding;
            this._is8859Encoded = encoding.equalsIgnoreCase("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            this._encoding = "utf-8";
            this._writer = new OutputStreamWriter(out, "utf-8");
        }
    }

    public void setIndentNumber(int value) {
        this._indentNumber = value;
    }

    public void setDoctype(String system, String pub) {
        this._doctypeSystem = system;
        this._doctypePublic = pub;
    }

    public void setIndent(boolean indent) {
        this._indent = indent;
    }

    public void omitHeader(boolean value) {
        this._omitHeader = value;
    }

    public void setStandalone(String standalone) {
        this._standalone = standalone;
    }

    public void setVersion(String version2) {
        this._version = version2;
    }

    protected void outputBuffer() {
        try {
            this._writer.write(this._buffer.close());
        }
        catch (IOException e) {}
    }

    protected void appendDTD(String name) {
        this._buffer.append("<!DOCTYPE ").append(name);
        if (this._doctypePublic == null) {
            this._buffer.append(" SYSTEM");
        } else {
            this._buffer.append(" PUBLIC \"").append(this._doctypePublic).append("\"");
        }
        if (this._doctypeSystem != null) {
            this._buffer.append(" \"").append(this._doctypeSystem).append("\">\n");
        } else {
            this._buffer.append(">\n");
        }
    }

    protected void indent(boolean linefeed) {
        if (linefeed) {
            this._buffer.append('\n');
        }
        this._buffer.append(INDENT, 0, this._indentLevel < MAX_INDENT_LEVEL ? this._indentLevel * this._indentNumber : MAX_INDENT);
    }

    protected void escapeCharacters(char[] ch, int off, int len) {
    }

    protected void appendAttributes() {
        if (!this._attributes.isEmpty()) {
            int i = 0;
            int length = this._attributes.size();
            do {
                Attribute attr = (Attribute)this._attributes.elementAt(i);
                this._buffer.append(' ').append(attr.name).append("=\"").append(attr.value).append('\"');
            } while (++i < length);
            this._attributes.clear();
        }
    }

    protected void closeStartTag() throws TransletException {
        this.appendAttributes();
        this._buffer.append('>');
        this._startTagOpen = false;
    }

    protected void appendComment(String comment) throws TransletException {
        boolean lastIsDash = false;
        int n = comment.length();
        this._buffer.append("<!--");
        int i = 0;
        while (i < n) {
            boolean isDash;
            char ch = comment.charAt(i);
            boolean bl = isDash = ch == '-';
            if (lastIsDash && isDash) {
                this._buffer.append(" -");
            } else {
                this._buffer.append(ch);
            }
            lastIsDash = isDash;
            ++i;
        }
        if (lastIsDash) {
            this._buffer.append(' ');
        }
        this._buffer.append("-->");
    }

    static {
        _canonicalEncodings.put("ebcdic-cp-us", "Cp037");
        _canonicalEncodings.put("ebcdic-cp-ca", "Cp037");
        _canonicalEncodings.put("ebcdic-cp-nl", "Cp037");
        _canonicalEncodings.put("ebcdic-cp-dk", "Cp277");
        _canonicalEncodings.put("ebcdic-cp-no", "Cp277");
        _canonicalEncodings.put("ebcdic-cp-fi", "Cp278");
        _canonicalEncodings.put("ebcdic-cp-se", "Cp278");
        _canonicalEncodings.put("ebcdic-cp-it", "Cp280");
        _canonicalEncodings.put("ebcdic-cp-es", "Cp284");
        _canonicalEncodings.put("ebcdic-cp-gb", "Cp285");
        _canonicalEncodings.put("ebcdic-cp-fr", "Cp297");
        _canonicalEncodings.put("ebcdic-cp-ar1", "Cp420");
        _canonicalEncodings.put("ebcdic-cp-he", "Cp424");
        _canonicalEncodings.put("ebcdic-cp-ch", "Cp500");
        _canonicalEncodings.put("ebcdic-cp-roece", "Cp870");
        _canonicalEncodings.put("ebcdic-cp-yu", "Cp870");
        _canonicalEncodings.put("ebcdic-cp-is", "Cp871");
        _canonicalEncodings.put("ebcdic-cp-ar2", "Cp918");
    }

    static class Attribute {
        public String name;
        public String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            try {
                return this.name.equalsIgnoreCase(((Attribute)obj).name);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

