/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.StripFilter;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.dom.DOMImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMAdapter
implements DOM {
    private final DOMImpl _domImpl;
    private String[] _namesArray;
    private String[] _namespaceArray;
    private short[] _mapping = null;
    private short[] _reverse = null;
    private short[] _NSmapping = null;
    private short[] _NSreverse = null;
    private StripFilter _filter = null;
    private int _multiDOMMask;

    public DOMAdapter(DOMImpl dom, String[] namesArray, String[] namespaceArray) {
        this._domImpl = dom;
        this._namesArray = namesArray;
        this._namespaceArray = namespaceArray;
    }

    public void setupMapping(String[] names, String[] namespaces) {
        this._namesArray = names;
        this._namespaceArray = namespaces;
    }

    private short[] getMapping() {
        if (this._mapping == null) {
            this._mapping = this._domImpl.getMapping(this._namesArray);
        }
        return this._mapping;
    }

    private short[] getReverse() {
        if (this._reverse == null) {
            this._reverse = this._domImpl.getReverseMapping(this._namesArray);
        }
        return this._reverse;
    }

    private short[] getNSMapping() {
        if (this._NSmapping == null) {
            this._NSmapping = this._domImpl.getNamespaceMapping(this._namespaceArray);
        }
        return this._NSmapping;
    }

    private short[] getNSReverse() {
        if (this._NSreverse == null) {
            this._NSreverse = this._domImpl.getReverseNamespaceMapping(this._namespaceArray);
        }
        return this._NSreverse;
    }

    public NodeIterator getIterator() {
        return this._domImpl.getIterator();
    }

    public String getStringValue() {
        return this._domImpl.getStringValue();
    }

    public String getTreeString() {
        return this._domImpl.getTreeString();
    }

    public int getMultiDOMMask() {
        return this._multiDOMMask;
    }

    public void setMultiDOMMask(int mask) {
        this._multiDOMMask = mask;
    }

    public NodeIterator getChildren(int node) {
        NodeIterator iterator = this._domImpl.getChildren(node);
        if (this._filter == null) {
            return iterator.setStartNode(node);
        }
        iterator = this._domImpl.strippingIterator(iterator, this.getMapping(), this._filter);
        return iterator.setStartNode(node);
    }

    public void setFilter(StripFilter filter) {
        this._filter = filter;
    }

    public NodeIterator getTypedChildren(int type) {
        short[] reverse = this.getReverse();
        NodeIterator iterator = this._domImpl.getTypedChildren(reverse[type]);
        if (reverse[type] == 1 && this._filter != null) {
            return this._domImpl.strippingIterator(iterator, this.getMapping(), this._filter);
        }
        return iterator;
    }

    public NodeIterator getNamespaceAxisIterator(int axis, int ns) {
        return this._domImpl.getNamespaceAxisIterator(axis, this.getNSReverse()[ns]);
    }

    public NodeIterator getAxisIterator(int axis) {
        NodeIterator iterator = this._domImpl.getAxisIterator(axis);
        if (this._filter != null) {
            return this._domImpl.strippingIterator(iterator, this.getMapping(), this._filter);
        }
        return iterator;
    }

    public NodeIterator getTypedAxisIterator(int axis, int type) {
        short[] reverse = this.getReverse();
        short[] NSreverse = this.getNSReverse();
        NodeIterator iterator = axis == 9 ? (type == -1 || type > NSreverse.length ? this._domImpl.getAxisIterator(axis) : this._domImpl.getTypedAxisIterator(axis, NSreverse[type])) : this._domImpl.getTypedAxisIterator(axis, reverse[type]);
        if (reverse[type] == 1 && this._filter != null) {
            iterator = this._domImpl.strippingIterator(iterator, this.getMapping(), this._filter);
        }
        return iterator;
    }

    public NodeIterator getNthDescendant(int type, int n, boolean includeself) {
        return this._domImpl.getNthDescendant(this.getReverse()[type], n, includeself);
    }

    public NodeIterator getNodeValueIterator(NodeIterator iterator, int type, String value, boolean op) {
        return this._domImpl.getNodeValueIterator(iterator, type, value, op);
    }

    public NodeIterator orderNodes(NodeIterator source, int node) {
        return this._domImpl.orderNodes(source, node);
    }

    public int getType(int node) {
        return this.getMapping()[this._domImpl.getType(node)];
    }

    public int getNamespaceType(int node) {
        return this.getNSMapping()[this._domImpl.getNamespaceType(node)];
    }

    public int getParent(int node) {
        return this._domImpl.getParent(node);
    }

    public int getAttributeNode(int type, int element) {
        return this._domImpl.getAttributeNode(this.getReverse()[type], element);
    }

    public String getNodeName(int node) {
        return this._domImpl.getNodeName(node);
    }

    public String getNamespaceName(int node) {
        return this._domImpl.getNamespaceName(node);
    }

    public String getNodeValue(int node) {
        return this._domImpl.getNodeValue(node);
    }

    public void copy(int node, TransletOutputHandler handler) throws TransletException {
        this._domImpl.copy(node, handler);
    }

    public void copy(NodeIterator nodes, TransletOutputHandler handler) throws TransletException {
        this._domImpl.copy(nodes, handler);
    }

    public String shallowCopy(int node, TransletOutputHandler handler) throws TransletException {
        return this._domImpl.shallowCopy(node, handler);
    }

    public boolean lessThan(int node1, int node2) {
        return this._domImpl.lessThan(node1, node2);
    }

    public void characters(int textNode, TransletOutputHandler handler) throws TransletException {
        this._domImpl.characters(textNode, handler);
    }

    public Node makeNode(int index) {
        return this._domImpl.makeNode(index);
    }

    public Node makeNode(NodeIterator iter) {
        return this._domImpl.makeNode(iter);
    }

    public NodeList makeNodeList(int index) {
        return this._domImpl.makeNodeList(index);
    }

    public NodeList makeNodeList(NodeIterator iter) {
        return this._domImpl.makeNodeList(iter);
    }

    public String getLanguage(int node) {
        return this._domImpl.getLanguage(node);
    }

    public int getSize() {
        return this._domImpl.getSize();
    }

    public void setDocumentURI(String uri) {
        this._domImpl.setDocumentURI(uri);
    }

    public String getDocumentURI() {
        return this._domImpl.getDocumentURI();
    }

    public String getDocumentURI(int node) {
        return this._domImpl.getDocumentURI();
    }

    public boolean isElement(int node) {
        return this._domImpl.isElement(node);
    }

    public boolean isAttribute(int node) {
        return this._domImpl.isAttribute(node);
    }

    public String lookupNamespace(int node, String prefix) throws TransletException {
        return this._domImpl.lookupNamespace(node, prefix);
    }
}

