/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.html.dom.HTMLElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLScriptElement;

public class HTMLScriptElementImpl
extends HTMLElementImpl
implements HTMLScriptElement {
    public boolean getDefer() {
        return this.getBinary("defer");
    }

    public void setDefer(boolean defer) {
        this.setAttribute("defer", defer);
    }

    public String getCharset() {
        return this.getAttribute("charset");
    }

    public String getEvent() {
        return this.getAttribute("event");
    }

    public String getHtmlFor() {
        return this.getAttribute("for");
    }

    public String getSrc() {
        return this.getAttribute("src");
    }

    public String getText() {
        Node child = this.getFirstChild();
        String text = "";
        while (child != null) {
            if (child instanceof Text) {
                text = text + ((Text)child).getData();
            }
            child = child.getNextSibling();
        }
        return text;
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setCharset(String charset) {
        this.setAttribute("charset", charset);
    }

    public void setEvent(String event) {
        this.setAttribute("event", event);
    }

    public void setHtmlFor(String htmlFor) {
        this.setAttribute("for", htmlFor);
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public void setText(String text) {
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            this.removeChild(child);
            child = next;
        }
        this.insertBefore(this.getOwnerDocument().createTextNode(text), this.getFirstChild());
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public HTMLScriptElementImpl(HTMLDocumentImpl owner, String name) {
        super(owner, name);
    }
}

