/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.tools.xmlutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.biomage.BioAssayData.DataInternal;
import org.biomage.Common.Extendable;
import org.biomage.Common.MAGEJava;
import org.biomage.Common.NameValueType;
import org.biomage.tools.helpers.StringOutputHelpers;
import org.biomage.tools.xmlutils.MultiHashMap;
import org.biomage.tools.xmlutils.MultiMap;
import org.biomage.tools.xmlutils.PCDataImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class MAGEContentHandler
extends DefaultHandler {
    protected MAGEJava mageJava = this.createMAGEJava();
    protected Map identifierMap = this.createIdentifierMap();
    protected Map classConstructorMap = this.createClassConstructorMap();
    protected Map methodsMap = this.createMethodsMap();
    protected Stack objectStack = this.createObjectStack();
    protected Stack associationStack = this.createAssociationStack();
    protected LinkedList unresolvedRefList = this.createUnresolvedRefList();
    protected PCDataImpl pcDataStack = null;
    protected boolean lastDocument = true;
    static /* synthetic */ Class class$org$xml$sax$Attributes;

    public MAGEJava getMAGEJava() {
        return this.mageJava;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void setLastDocument(boolean b) {
        this.lastDocument = b;
    }

    public boolean getLastDocument() {
        return this.lastDocument;
    }

    public void endDocument() throws SAXException {
        if (!this.lastDocument) {
            return;
        }
        try {
            StringOutputHelpers.writeOutput("Fixing unresolved references: Count = " + this.unresolvedRefList.size(), 3);
            ListIterator iter = this.unresolvedRefList.listIterator(0);
            while (iter.hasNext()) {
                UnresolvedRef uRef = (UnresolvedRef)iter.next();
                Object refdObj = this.identifierMap.get(uRef.childIdentifier);
                if (refdObj != null) {
                    this.makeAssociation(uRef.associationType, uRef.parent, refdObj);
                    continue;
                }
                StringOutputHelpers.writeOutput("A reference ( refid = " + uRef.childIdentifier + " ) to a " + uRef.childType + " not found!", 3);
                AttributesImpl idAttr = new AttributesImpl();
                idAttr.addAttribute("", "identifier", "identifier", "", uRef.childIdentifier);
                this.createMAGEObject(uRef.childType, idAttr);
                Extendable newObj = (Extendable)this.objectStack.pop();
                NameValueType nvt = new NameValueType();
                nvt.setName("Placeholder");
                newObj.addToPropertySets(nvt);
                StringOutputHelpers.writeOutput("Popping " + newObj.getClass().getName() + " from object stack", 3);
                this.makeAssociation(uRef.associationType, uRef.parent, newObj);
            }
            StringOutputHelpers.writeOutput("Dangling object count: " + this.objectStack.size(), 3);
            Vector pckgList = new Vector();
            while (!this.objectStack.empty()) {
                pckgList.add(this.objectStack.pop());
            }
            int i = 0;
            while (i < pckgList.size()) {
                Object pckg1 = pckgList.get(i);
                int j = i + 1;
                while (j < pckgList.size()) {
                    Object pckg2 = pckgList.get(j);
                    if (!pckg1.getClass().getName().endsWith("String") && pckg1.getClass().getName().equals(pckg2.getClass().getName())) {
                        this.mergePckgs(pckg1, pckg2);
                        pckgList.remove(j);
                        continue;
                    }
                    ++j;
                }
                ++i;
            }
            int j = pckgList.size() - 1;
            while (j >= 0) {
                this.objectStack.push(pckgList.get(j));
                --j;
            }
            while (!this.objectStack.empty()) {
                Object pkgObj = this.objectStack.pop();
                String associationName = pkgObj.getClass().getName();
                int index = associationName.lastIndexOf(".");
                if (index > 0) {
                    associationName = associationName.substring(index + 1);
                }
                StringOutputHelpers.writeOutput("now association name = " + associationName, 3);
                this.makeAssociation(new Association(associationName, "assn"), this.mageJava, pkgObj);
            }
        }
        catch (Exception e) {
            System.err.println("Caught exception in endDocument: " + e);
            e.printStackTrace();
        }
    }

    protected void mergePckgs(Object pckg1, Object pckg2) {
        try {
            Field[] pckgFields = pckg1.getClass().getFields();
            int i = 0;
            while (i < pckgFields.length) {
                Method getMethod = pckg1.getClass().getMethod("get" + StringOutputHelpers.initialCap(pckgFields[i].getName()), null);
                Object container1 = getMethod.invoke(pckg1, null);
                Object container2 = getMethod.invoke(pckg2, null);
                Method sizeMethod = container1.getClass().getMethod("size", null);
                int sizeContainer1 = (Integer)sizeMethod.invoke(container1, null);
                int sizeContainer2 = (Integer)sizeMethod.invoke(container2, null);
                if (sizeContainer1 == 0) {
                    if (sizeContainer2 > 0) {
                        Method setMethod = pckg1.getClass().getMethod("set" + StringOutputHelpers.initialCap(pckgFields[i].getName()), container2.getClass());
                        setMethod.invoke(pckg1, container2);
                    }
                } else if (sizeContainer2 > 0) {
                    Method getElementMethod = pckg1.getClass().getMethod("getFrom" + StringOutputHelpers.initialCap(pckgFields[i].getName()), Integer.TYPE);
                    int index = pckgFields[i].getName().lastIndexOf(95);
                    String elementType = new String(pckg1.getClass().getPackage().getName() + "." + StringOutputHelpers.initialCap(pckgFields[i].getName().substring(0, index)));
                    Method setElementMethod = pckg1.getClass().getMethod("addTo" + StringOutputHelpers.initialCap(pckgFields[i].getName()), Class.forName(elementType));
                    Object element = null;
                    int j = 0;
                    while (j < sizeContainer2) {
                        element = getElementMethod.invoke(pckg2, new Integer(j));
                        setElementMethod.invoke(pckg1, element);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        block15: {
            try {
                String tagPrefix = localName;
                String tagSuffix = null;
                int index = 0;
                Object parent = null;
                if (localName.equals("")) {
                    localName = qualifiedName;
                }
                StringOutputHelpers.writeOutput("startElement: " + localName, 1);
                if (!this.objectStack.empty()) {
                    parent = this.objectStack.peek();
                }
                if ((index = localName.indexOf("_")) > -1) {
                    tagPrefix = localName.substring(0, index);
                    tagSuffix = localName.substring(index + 1);
                }
                if (tagPrefix.equals("MAGE-ML")) {
                    StringOutputHelpers.writeOutput("Found MAGE-ML tag....ignoring for now", 3);
                    return;
                }
                if (tagSuffix == null || tagSuffix.equals("package")) {
                    this.createMAGEObject(localName, atts);
                    if (parent != null && !this.objectStack.isEmpty() && !this.associationStack.isEmpty()) {
                        this.makeAssociation((Association)this.associationStack.peek(), parent, this.objectStack.peek());
                    }
                } else if (tagSuffix.equals("assn") || tagSuffix.equals("assnref") || tagSuffix.equals("assnlist") || tagSuffix.equals("assnreflist")) {
                    StringOutputHelpers.writeOutput("Found ref.." + tagPrefix + ".pushing on stack " + tagSuffix, 3);
                    this.associationStack.push(new Association(tagPrefix, tagSuffix));
                } else {
                    int identIndex = atts.getIndex("", "identifier");
                    if (identIndex == -1) {
                        System.err.println("Hey. startElement is starting an element with no identifier attribute.  Returning now.");
                        return;
                    }
                    Object newChild = this.identifierMap.get(atts.getValue(identIndex));
                    if (newChild == null) {
                        StringOutputHelpers.writeOutput("Cannot resolve...storing unresolved ref for later.", 3);
                        this.unresolvedRefList.add(new UnresolvedRef((Association)this.associationStack.peek(), parent, atts.getValue(identIndex), tagPrefix));
                    } else {
                        StringOutputHelpers.writeOutput("Located ref'd object by identifier map!", 3);
                        this.makeAssociation((Association)this.associationStack.peek(), parent, newChild);
                    }
                }
                parent = null;
                if (!localName.equals("DataInternal")) break block15;
                this.pcDataStack = new PCDataImpl();
                DataInternal pcDataContainingElement = (DataInternal)this.objectStack.peek();
                if (pcDataContainingElement != null) {
                    pcDataContainingElement.setPcData(this.pcDataStack);
                    break block15;
                }
                throw new SAXException("No owner object of PCDATA found ...");
            }
            catch (Exception e) {
                System.err.println("Caught exception in startElement: " + e);
                e.printStackTrace();
            }
        }
    }

    public void makeAssociation(Association association_info, Object parent, Object child) throws SAXException {
        Method set_method = null;
        StringOutputHelpers.writeOutput("makeAssociation:", 1);
        StringOutputHelpers.writeOutput("  Parent type = " + parent.getClass().getName(), 2);
        StringOutputHelpers.writeOutput("  Child type = " + child.getClass().getName(), 2);
        StringOutputHelpers.writeOutput("  Association name = " + association_info.name, 2);
        StringOutputHelpers.writeOutput("  Association type = " + association_info.type, 2);
        String method_name = association_info.type.equals("assn") || association_info.type.equals("assnref") ? "set" + StringOutputHelpers.initialCap(association_info.name) : "addTo" + StringOutputHelpers.initialCap(association_info.name);
        if (this.methodsMap.containsKey(method_name)) {
            Iterator methods_iterator = ((Set)this.methodsMap.get(method_name)).iterator();
            while (methods_iterator.hasNext()) {
                set_method = (Method)methods_iterator.next();
                if (set_method.getDeclaringClass().isInstance(parent)) break;
                set_method = null;
            }
        }
        if (set_method == null) {
            StringOutputHelpers.writeOutput("    Trying to find method: " + method_name + "[_list]", 3);
            Method[] parent_methods = null;
            try {
                parent_methods = parent.getClass().getMethods();
            }
            catch (SecurityException e) {
                throw new SAXException(e);
            }
            int i = 0;
            while (i < parent_methods.length) {
                StringOutputHelpers.writeOutput("      Checking method: " + parent_methods[i].getName(), 4);
                if ((parent_methods[i].getName().equals(method_name) || parent_methods[i].getName().equals(method_name + "_list")) && parent_methods[i].getParameterTypes().length == 1) {
                    set_method = parent_methods[i];
                    this.methodsMap.put(method_name, set_method);
                    break;
                }
                ++i;
            }
        }
        if (set_method == null) {
            StringOutputHelpers.writeOutput("    Method Not Found!", 2);
        } else {
            StringOutputHelpers.writeOutput("    Found method " + set_method.getName() + "!  Calling it...", 3);
            try {
                set_method.invoke(parent, child);
            }
            catch (IllegalAccessException e) {
                throw new SAXException(e);
            }
            catch (InvocationTargetException e) {
                throw new SAXException(e);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        block7: {
            try {
                if (localName.equals("")) {
                    localName = qualifiedName;
                }
                StringOutputHelpers.writeOutput("endElement: " + localName, 1);
                if (localName.endsWith("_assn") || localName.endsWith("_assnlist") || localName.endsWith("_assnref") || localName.endsWith("_assnreflist")) {
                    Association association_info = (Association)this.associationStack.pop();
                    StringOutputHelpers.writeOutput("  Popped " + association_info.name + " from association stack", 3);
                } else if (!(localName.endsWith("_ref") || localName.endsWith("_package") || localName.equals("MAGE-ML") || localName.indexOf("_") >= 0)) {
                    Object objInfo = this.objectStack.pop();
                    StringOutputHelpers.writeOutput("  Popped " + objInfo.getClass().getName() + " from object stack", 3);
                }
                if (!localName.equals("DataInternal")) break block7;
                if (this.pcDataStack != null) {
                    this.pcDataStack = null;
                    break block7;
                }
                throw new SAXException("No object on pcDataStack when closing PCDATA containing element");
            }
            catch (Exception e) {
                System.err.println("Caught exception in endElement: " + e);
                e.printStackTrace();
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void characters(char[] text, int start, int length) throws SAXException {
        Object parent = !this.objectStack.empty() ? (Object)this.objectStack.peek() : null;
        if (parent != null && parent.getClass().getName().equals("org.biomage.BioAssayData.DataInternal")) {
            if (this.pcDataStack != null) {
                this.pcDataStack.appendChars(text, start, length);
            } else {
                throw new SAXException("No object on pcDataStack when receiving chars in a PCDATA containing element");
            }
        }
    }

    public void ignorableWhitespace(char[] text, int start, int length) throws SAXException {
        Object parent = !this.objectStack.empty() ? (Object)this.objectStack.peek() : null;
        if (parent != null && parent.getClass().getName().equals("org.biomage.BioAssayData.DataInternal")) {
            if (this.pcDataStack != null) {
                this.pcDataStack.appendChars(text, start, length);
            } else {
                throw new SAXException("No object on pcDataStack when receiving whitespace in a PCDATA containing element");
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    protected String createMAGEObject(String localName, Attributes atts) throws SAXException {
        Constructor constructor;
        Class mageClass = this.mageJava.getClassWithModelName(localName);
        if (mageClass == null) {
            StringOutputHelpers.writeOutput("Don't know how to create an object  for " + localName + " yet! Skipping.", 3);
            this.objectStack.push(new String("localName"));
            return null;
        }
        int nIdentifierIndex = atts.getIndex("", "identifier");
        String sIdentifier = null;
        if (nIdentifierIndex != -1) {
            sIdentifier = atts.getValue(nIdentifierIndex);
        }
        if ((constructor = (Constructor)this.classConstructorMap.get(mageClass)) == null) {
            StringOutputHelpers.writeOutput("Creating a class constructor " + localName, 3);
            try {
                constructor = mageClass.getConstructor(class$org$xml$sax$Attributes == null ? (class$org$xml$sax$Attributes = MAGEContentHandler.class$("org.xml.sax.Attributes")) : class$org$xml$sax$Attributes);
            }
            catch (NoSuchMethodException e) {
                throw new SAXException(e);
            }
            catch (SecurityException e) {
                throw new SAXException(e);
            }
            this.classConstructorMap.put(mageClass, constructor);
        }
        StringOutputHelpers.writeOutput("Calling the class constructor for " + localName, 3);
        Object object = null;
        try {
            object = constructor.newInstance(atts);
        }
        catch (IllegalAccessException e) {
            throw new SAXException(e);
        }
        catch (InstantiationException e) {
            throw new SAXException(e);
        }
        catch (InvocationTargetException e) {
            throw new SAXException(e);
        }
        if (sIdentifier != null) {
            if (this.identifierMap.containsKey(sIdentifier)) {
                StringOutputHelpers.writeOutput("WARNING: The identifier \"" + sIdentifier + "\" is already associated with an object.", 2);
            } else {
                this.identifierMap.put(sIdentifier, object);
            }
        }
        this.objectStack.push(object);
        return sIdentifier;
    }

    protected MAGEJava createMAGEJava() {
        return new MAGEJava();
    }

    protected Map createIdentifierMap() {
        return new HashMap();
    }

    protected MultiMap createMethodsMap() {
        return new MultiHashMap();
    }

    protected Map createClassConstructorMap() {
        return new HashMap();
    }

    protected Stack createAssociationStack() {
        return new Stack();
    }

    protected Stack createObjectStack() {
        return new Stack();
    }

    protected LinkedList createUnresolvedRefList() {
        return new LinkedList();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class UnresolvedRef {
        protected Association associationType;
        protected Object parent;
        protected String childIdentifier;
        protected String childType;

        public UnresolvedRef(Association association_type, Object parent, String child_identifier, String child_type) {
            this.associationType = association_type;
            this.parent = parent;
            this.childIdentifier = child_identifier;
            this.childType = child_type;
        }
    }

    class Association {
        protected String name;
        protected String type;

        public Association(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

