/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.AuditAndSecurity.Contact;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasHardwareManufacturers;
import org.biomage.Interface.HasSoftwares;
import org.biomage.Interface.HasType;
import org.biomage.Protocol.Parameterizable;
import org.biomage.Protocol.Software;
import org.xml.sax.Attributes;

public class Hardware
extends Parameterizable
implements Serializable,
HasHardwareManufacturers,
HasSoftwares,
HasType {
    String model;
    String make;
    protected OntologyEntry type;
    protected HasSoftwares.Softwares_list softwares = new HasSoftwares.Softwares_list();
    protected HasHardwareManufacturers.HardwareManufacturers_list hardwareManufacturers = new HasHardwareManufacturers.HardwareManufacturers_list();

    public Hardware() {
    }

    public Hardware(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "model");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.model = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "make")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.make = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Hardware");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Hardware>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.model != null) {
            out.write(" model=\"" + this.model + "\"");
        }
        if (this.make != null) {
            out.write(" make=\"" + this.make + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        String modelClassName;
        int i;
        super.writeAssociations(out);
        if (this.type != null) {
            out.write("<Type_assn>");
            this.type.writeMAGEML(out);
            out.write("</Type_assn>");
        }
        if (this.softwares.size() > 0) {
            out.write("<Softwares_assnreflist>");
            for (i = 0; i < this.softwares.size(); ++i) {
                modelClassName = ((Software)this.softwares.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Software)this.softwares.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Softwares_assnreflist>");
        }
        if (this.hardwareManufacturers.size() > 0) {
            out.write("<HardwareManufacturers_assnreflist>");
            for (i = 0; i < this.hardwareManufacturers.size(); ++i) {
                modelClassName = ((Contact)this.hardwareManufacturers.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Contact)this.hardwareManufacturers.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</HardwareManufacturers_assnreflist>");
        }
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public String getMake() {
        return this.make;
    }

    public String getModelClassName() {
        return new String("Hardware");
    }

    public void setType(OntologyEntry type) {
        this.type = type;
    }

    public OntologyEntry getType() {
        return this.type;
    }

    public void setSoftwares(HasSoftwares.Softwares_list softwares) {
        this.softwares = softwares;
    }

    public HasSoftwares.Softwares_list getSoftwares() {
        return this.softwares;
    }

    public void addToSoftwares(Software software) {
        this.softwares.add(software);
    }

    public void addToSoftwares(int position, Software software) {
        this.softwares.add(position, software);
    }

    public Software getFromSoftwares(int position) {
        return (Software)this.softwares.get(position);
    }

    public void removeElementAtFromSoftwares(int position) {
        this.softwares.removeElementAt(position);
    }

    public void removeFromSoftwares(Software software) {
        this.softwares.remove(software);
    }

    public void setHardwareManufacturers(HasHardwareManufacturers.HardwareManufacturers_list hardwareManufacturers) {
        this.hardwareManufacturers = hardwareManufacturers;
    }

    public HasHardwareManufacturers.HardwareManufacturers_list getHardwareManufacturers() {
        return this.hardwareManufacturers;
    }

    public void addToHardwareManufacturers(Contact contact) {
        this.hardwareManufacturers.add(contact);
    }

    public void addToHardwareManufacturers(int position, Contact contact) {
        this.hardwareManufacturers.add(position, contact);
    }

    public Contact getFromHardwareManufacturers(int position) {
        return (Contact)this.hardwareManufacturers.get(position);
    }

    public void removeElementAtFromHardwareManufacturers(int position) {
        this.hardwareManufacturers.removeElementAt(position);
    }

    public void removeFromHardwareManufacturers(Contact contact) {
        this.hardwareManufacturers.remove(contact);
    }
}

