### Name: rebuild.cov
### Title: Rebuild Covariance Matrix from Correlation Matrix
### Aliases: rebuild.cov
### Keywords: multivariate

### ** Examples

# load GeneTS library
library(GeneTS)

# first 10 genes from the caulobacter data set
data(caulobacter)
m <- caulobacter[,1:10]

# covariance matrix
m.cov <- cov(m)
m.cov

# variances
m.var <- diag(m.cov)
m.var

# correlation matrix
m.cor.1 <- cor(m)
m.cor.1

# correlation matrix via covariance matrix
m.cor.2 <- cov2cor(m.cov)
m.cor.2

zapsmall(m.cor.1) == zapsmall(m.cor.2)

# reconstruct covariance matrix
rebuild.cov(m.cor.1, m.var)




