### Name: cor.fit.mixture
### Title: Graphical Gaussian Models: Fit Mixture Distribution to Sample
###   Correlation Coefficients
### Aliases: cor.fit.mixture
### Keywords: htest

### ** Examples

# load GeneTS library
library(GeneTS)

# simulate mixture distribution
r <- rcor0(700, kappa=10)
u <- runif(200, min=-1, max=1)
rc <- c(r,u)

# estimate kappa and eta0 (=7/9)
c1 <- cor.fit.mixture(r, fA.type="uniform")
c1$eta0
c1$kappa
c2 <- cor.fit.mixture(rc, fA.type="uniform") 
c2$eta0
c2$kappa

# for comparison
cor0.estimate.kappa(r)
cor0.estimate.kappa(rc)



