### Name: bagging
### Title: Bagged Versions of Covariance and (Partial) Correlation Matrix
### Aliases: bagged.cov bagged.cor bagged.pcor
### Keywords: multivariate

### ** Examples

# load GeneTS library
library(GeneTS)

# small example data set 
data(caulobacter)
dat <- caulobacter[,1:15]
dim(dat)

# bagged estimates
b.cov <- bagged.cov(dat)
b.cor <- bagged.cor(dat)
b.pcor <- bagged.pcor(dat)

# total squared difference
sum( (b.cov - cov(dat))^2  )
sum( (b.cor - cor(dat))^2  )
sum( (b.pcor - partial.cor(dat))^2  )

# positive definiteness of bagged correlation
is.positive.definite(cor(dat))
is.positive.definite(b.cor)



